/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import io.netty.buffer.ByteBuf;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.util.LangUtils;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityReactorLogicAdapter
extends TileEntityReactorBlock
implements IComputerIntegration {
    private static final String[] methods = new String[]{"isIgnited", "canIgnite", "getPlasmaHeat", "getMaxPlasmaHeat", "getCaseHeat", "getMaxCaseHeat", "getInjectionRate", "setInjectionRate", "hasFuel", "getProducing", "getIgnitionTemp", "getEnergy", "getMaxEnergy", "getWater", "getSteam", "getFuel", "getDeuterium", "getTritium"};
    public ReactorLogic logicType = ReactorLogic.DISABLED;
    public boolean activeCooled;
    public boolean prevOutputting;

    public TileEntityReactorLogicAdapter() {
        this.fullName = "ReactorLogicAdapter";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            boolean outputting = this.checkMode();
            if (outputting != this.prevOutputting) {
                Mekanism.EXECUTE_MANAGER.addSyncTask(() -> this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true));
            }
            this.prevOutputting = outputting;
        }
    }

    @Override
    public boolean isFrame() {
        return false;
    }

    public boolean checkMode() {
        boolean bl;
        if (this.field_145850_b.field_72995_K) {
            return this.prevOutputting;
        }
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return false;
        }
        switch (this.logicType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DISABLED: {
                bl = false;
                break;
            }
            case READY: {
                if (this.getReactor().getPlasmaTemp() >= this.getReactor().getIgnitionTemperature(this.activeCooled)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case CAPACITY: {
                if (this.getReactor().getPlasmaTemp() >= this.getReactor().getMaxPlasmaTemperature(this.activeCooled)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case DEPLETED: {
                bl = this.getReactor().getDeuteriumTank().getStored() < this.getReactor().getInjectionRate() / 2 || this.getReactor().getTritiumTank().getStored() < this.getReactor().getInjectionRate() / 2;
            }
        }
        return bl;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.logicType = ReactorLogic.values()[nbtTags.func_74762_e("logicType")];
        this.activeCooled = nbtTags.func_74767_n("activeCooled");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("logicType", this.logicType.ordinal());
        nbtTags.func_74757_a("activeCooled", this.activeCooled);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.activeCooled = !this.activeCooled;
            } else if (type == 1) {
                this.logicType = ReactorLogic.values()[dataStream.readInt()];
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.logicType = ReactorLogic.values()[dataStream.readInt()];
            this.activeCooled = dataStream.readBoolean();
            this.prevOutputting = dataStream.readBoolean();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.logicType.ordinal());
        data.add(this.activeCooled);
        data.add(this.prevOutputting);
        return data;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return new Object[]{"Unformed."};
        }
        switch (method) {
            case 0: {
                return new Object[]{this.getReactor().isBurning()};
            }
            case 1: {
                return new Object[]{this.getReactor().getPlasmaTemp() >= this.getReactor().getIgnitionTemperature(this.activeCooled)};
            }
            case 2: {
                return new Object[]{this.getReactor().getPlasmaTemp()};
            }
            case 3: {
                return new Object[]{this.getReactor().getMaxPlasmaTemperature(this.activeCooled)};
            }
            case 4: {
                return new Object[]{this.getReactor().getCaseTemp()};
            }
            case 5: {
                return new Object[]{this.getReactor().getMaxCasingTemperature(this.activeCooled)};
            }
            case 6: {
                return new Object[]{this.getReactor().getInjectionRate()};
            }
            case 7: {
                if (arguments[0] instanceof Double) {
                    this.getReactor().setInjectionRate(((Double)arguments[0]).intValue());
                    return new Object[]{"Injection rate set."};
                }
                return new Object[]{"Invalid parameters."};
            }
            case 8: {
                return new Object[]{this.getReactor().getDeuteriumTank().getStored() >= this.getReactor().getInjectionRate() / 2 && this.getReactor().getTritiumTank().getStored() >= this.getReactor().getInjectionRate() / 2};
            }
            case 9: {
                return new Object[]{this.getReactor().getPassiveGeneration(false, true)};
            }
            case 10: {
                return new Object[]{this.getReactor().getIgnitionTemperature(this.activeCooled)};
            }
            case 11: {
                return new Object[]{this.getReactor().getBufferedEnergy()};
            }
            case 12: {
                return new Object[]{this.getReactor().getBufferSize()};
            }
            case 13: {
                return new Object[]{this.getReactor().getWaterTank().getFluidAmount()};
            }
            case 14: {
                return new Object[]{this.getReactor().getSteamTank().getFluidAmount()};
            }
            case 15: {
                return new Object[]{this.getReactor().getFuelTank().getStored()};
            }
            case 16: {
                return new Object[]{this.getReactor().getDeuteriumTank().getStored()};
            }
            case 17: {
                return new Object[]{this.getReactor().getTritiumTank().getStored()};
            }
        }
        throw new NoSuchMethodException();
    }

    public static enum ReactorLogic {
        DISABLED("disabled", new ItemStack(Items.field_151016_H)),
        READY("ready", new ItemStack(Items.field_151137_ax)),
        CAPACITY("capacity", new ItemStack(Items.field_151137_ax)),
        DEPLETED("depleted", new ItemStack(Items.field_151137_ax));

        private String name;
        private ItemStack renderStack;

        private ReactorLogic(String s, ItemStack stack) {
            this.name = s;
            this.renderStack = stack;
        }

        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getLocalizedName() {
            return LangUtils.localize("reactor." + this.name);
        }

        public String getDescription() {
            return LangUtils.localize("reactor." + this.name + ".desc");
        }
    }
}

