/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.base.IActiveState;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.FluidTankSync;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import mekanism.generators.common.FusionReactor;
import mekanism.generators.common.item.ItemHohlraum;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityReactorController
extends TileEntityReactorBlock
implements IActiveState {
    public FluidTank waterTank;
    public FluidTank steamTank;
    public GasTank deuteriumTank;
    public GasTank tritiumTank;
    public GasTank fuelTank;
    public AxisAlignedBB box;
    public double clientTemp;
    public boolean clientBurning;
    private SoundEvent soundEvent;
    @SideOnly(value=Side.CLIENT)
    private ISound activeSound;
    private int playSoundCooldown;

    public TileEntityReactorController() {
        super("ReactorController", MekanismConfig.current().generators.reactorGeneratorStorage.val());
        this.waterTank = new FluidTankSync(MekanismConfig.current().generators.FusionReactorsWaterTank.val());
        this.steamTank = new FluidTankSync(MekanismConfig.current().generators.FusionReactorsSteamTank.val());
        this.deuteriumTank = new GasTank(MekanismConfig.current().generators.FusionReactorsDeuteriumTank.val());
        this.tritiumTank = new GasTank(MekanismConfig.current().generators.FusionReactorsTritiumTank.val());
        this.fuelTank = new GasTank(MekanismConfig.current().generators.FusionReactorsFuelTank.val());
        this.clientTemp = 0.0;
        this.clientBurning = false;
        this.soundEvent = new SoundEvent(new ResourceLocation("mekanism", "tile.machine.fusionreactor"));
        this.playSoundCooldown = 0;
        this.inventory = NonNullListSynchronized.withSize(1, ItemStack.field_190927_a);
    }

    @Override
    public boolean isFrame() {
        return false;
    }

    public void radiateNeutrons(int neutrons) {
    }

    public void formMultiblock(boolean keepBurning) {
        if (this.getReactor() == null) {
            this.setReactor(new FusionReactor(this));
        }
        this.getReactor().formMultiblock(keepBurning);
    }

    public double getPlasmaTemp() {
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return 0.0;
        }
        return this.getReactor().getPlasmaTemp();
    }

    public double getCaseTemp() {
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return 0.0;
        }
        return this.getReactor().getCaseTemp();
    }

    public boolean getactivelyCooled() {
        return this.steamTank.getFluidAmount() < this.steamTank.getCapacity() && this.steamTank.getFluidAmount() != this.steamTank.getCapacity();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
        if (this.isFormed()) {
            this.getReactor().simulate();
            if (!this.field_145850_b.field_72995_K && (this.getReactor().isBurning() != this.clientBurning || Math.abs(this.getReactor().getPlasmaTemp() - this.clientTemp) > 1000000.0)) {
                Mekanism.packetHandler.sendUpdatePacket(this);
                this.clientBurning = this.getReactor().isBurning();
                this.clientTemp = this.getReactor().getPlasmaTemp();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (!MekanismConfig.current().client.enableMachineSounds.val()) {
            return;
        }
        if (this.isBurning() && !this.func_145837_r()) {
            if (--this.playSoundCooldown > 0) {
                return;
            }
            if (this.activeSound == null || !Minecraft.func_71410_x().func_147118_V().func_147692_c(this.activeSound)) {
                this.activeSound = SoundHandler.startTileSound(this.soundEvent.func_187503_a(), 1.0f, this.func_174877_v());
                this.playSoundCooldown = 20;
            }
        } else if (this.activeSound != null) {
            SoundHandler.stopTileSound(this.func_174877_v());
            this.activeSound = null;
            this.playSoundCooldown = 0;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.formMultiblock(true);
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.formMultiblock(false);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        super.writeCustomNBT(tag);
        tag.func_74757_a("formed", this.isFormed());
        if (this.isFormed()) {
            tag.func_74780_a("plasmaTemp", this.getReactor().getPlasmaTemp());
            tag.func_74780_a("caseTemp", this.getReactor().getCaseTemp());
            tag.func_74768_a("injectionRate", this.getReactor().getInjectionRate());
            tag.func_74757_a("burning", this.getReactor().isBurning());
        } else {
            tag.func_74780_a("plasmaTemp", 0.0);
            tag.func_74780_a("caseTemp", 0.0);
            tag.func_74768_a("injectionRate", 0);
            tag.func_74757_a("burning", false);
        }
        tag.func_74782_a("fuelTank", (NBTBase)this.fuelTank.write(new NBTTagCompound()));
        tag.func_74782_a("deuteriumTank", (NBTBase)this.deuteriumTank.write(new NBTTagCompound()));
        tag.func_74782_a("tritiumTank", (NBTBase)this.tritiumTank.write(new NBTTagCompound()));
        tag.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("steamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        super.readCustomNBT(tag);
        boolean formed = tag.func_74767_n("formed");
        if (formed) {
            this.setReactor(new FusionReactor(this));
            this.getReactor().setPlasmaTemp(tag.func_74769_h("plasmaTemp"));
            this.getReactor().setCaseTemp(tag.func_74769_h("caseTemp"));
            this.getReactor().setInjectionRate(tag.func_74762_e("injectionRate"));
            this.getReactor().setBurning(tag.func_74767_n("burning"));
            this.getReactor().updateTemperatures();
        }
        this.fuelTank.read(tag.func_74775_l("fuelTank"));
        this.deuteriumTank.read(tag.func_74775_l("deuteriumTank"));
        this.tritiumTank.read(tag.func_74775_l("tritiumTank"));
        this.waterTank.readFromNBT(tag.func_74775_l("waterTank"));
        this.steamTank.readFromNBT(tag.func_74775_l("steamTank"));
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.getReactor() != null && this.getReactor().isFormed());
        if (this.getReactor() != null) {
            data.add(this.getReactor().getPlasmaTemp());
            data.add(this.getReactor().getCaseTemp());
            data.add(this.getReactor().getInjectionRate());
            data.add(this.getReactor().isBurning());
            data.add(this.fuelTank.getStored());
            data.add(this.deuteriumTank.getStored());
            data.add(this.tritiumTank.getStored());
            TileUtils.addTankData(data, this.waterTank);
            TileUtils.addTankData(data, this.steamTank);
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0 && this.getReactor() != null) {
                this.getReactor().setInjectionRate(dataStream.readInt());
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            boolean formed = dataStream.readBoolean();
            if (formed) {
                if (this.getReactor() == null || !this.getReactor().formed) {
                    BlockPos corner = this.func_174877_v().func_177973_b(new Vec3i(2, 4, 2));
                    Mekanism.proxy.doMultiblockSparkle(this, corner, 5, 5, 6, tile -> tile instanceof TileEntityReactorBlock);
                }
                if (this.getReactor() == null) {
                    this.setReactor(new FusionReactor(this));
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
                this.getReactor().formed = true;
                this.getReactor().setPlasmaTemp(dataStream.readDouble());
                this.getReactor().setCaseTemp(dataStream.readDouble());
                this.getReactor().setInjectionRate(dataStream.readInt());
                this.getReactor().setBurning(dataStream.readBoolean());
                this.fuelTank.setGas(new GasStack(MekanismFluids.FusionFuel, dataStream.readInt()));
                this.deuteriumTank.setGas(new GasStack(MekanismFluids.Deuterium, dataStream.readInt()));
                this.tritiumTank.setGas(new GasStack(MekanismFluids.Tritium, dataStream.readInt()));
                TileUtils.readTankData(dataStream, this.waterTank);
                TileUtils.readTankData(dataStream, this.steamTank);
            } else if (this.getReactor() != null) {
                this.setReactor(null);
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    public boolean isFormed() {
        return this.getReactor() != null && this.getReactor().isFormed();
    }

    public boolean isBurning() {
        return this.getActive() && this.getReactor().isBurning();
    }

    @Override
    public boolean getActive() {
        return this.isFormed();
    }

    @Override
    public void setActive(boolean active) {
        if (active == (this.getReactor() == null)) {
            this.setReactor(active ? new FusionReactor(this) : null);
        }
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.box == null) {
            this.box = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)(this.func_174877_v().func_177956_o() - 3), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() + 2));
        }
        return this.box;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        int[] nArray;
        if (this.isFormed()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = InventoryUtils.EMPTY;
        }
        return nArray;
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemHohlraum;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return false;
        }
        return super.isCapabilityDisabled(capability, side);
    }
}

