/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.generators.common.FusionReactor;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityReactorBlock
extends TileEntityElectricBlock {
    public FusionReactor fusionReactor;
    public boolean attempted;
    public boolean changed;

    public TileEntityReactorBlock() {
        super("ReactorBlock", 0.0);
    }

    public TileEntityReactorBlock(String name, double maxEnergy) {
        super(name, maxEnergy);
    }

    public abstract boolean isFrame();

    public FusionReactor getReactor() {
        return this.fusionReactor;
    }

    public void setReactor(FusionReactor reactor) {
        if (reactor != this.fusionReactor) {
            this.changed = true;
        }
        this.fusionReactor = reactor;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.getReactor() != null) {
            this.getReactor().formMultiblock(false);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.changed) {
            this.changed = false;
        }
        if (!(this.field_145850_b.field_72995_K || this.ticker != 5 || this.attempted || this.getReactor() != null && this.getReactor().isFormed())) {
            this.updateController();
        }
        this.attempted = false;
    }

    @Override
    public boolean supportsAsync() {
        return false;
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return false;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return false;
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (!(this instanceof TileEntityReactorController) && this.getReactor() != null) {
            this.getReactor().formMultiblock(true);
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            if (this.getReactor() != null) {
                this.getReactor().formMultiblock(false);
            } else {
                this.updateController();
            }
        }
    }

    public void updateController() {
        TileEntityReactorController found;
        if (!(this instanceof TileEntityReactorController || (found = new ControllerFinder().find()) == null || found.getReactor() != null && found.getReactor().isFormed())) {
            found.formMultiblock(false);
        }
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    public class ControllerFinder {
        public TileEntityReactorController found;
        public Set<Coord4D> iterated = new HashSet<Coord4D>();

        public void loop(Coord4D pos) {
            if (this.iterated.size() > 512 || this.found != null) {
                return;
            }
            this.iterated.add(pos);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                TileEntity tileEntity;
                Coord4D coord = pos.offset(side);
                if (this.iterated.contains(coord) || !((tileEntity = coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b)) instanceof TileEntityReactorBlock)) continue;
                TileEntityReactorBlock block = (TileEntityReactorBlock)tileEntity;
                block.attempted = true;
                TileEntity tileEntity2 = coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b);
                if (tileEntity2 instanceof TileEntityReactorController) {
                    TileEntityReactorController controller;
                    this.found = controller = (TileEntityReactorController)tileEntity2;
                    return;
                }
                this.loop(coord);
            }
        }

        public TileEntityReactorController find() {
            this.loop(Coord4D.get(TileEntityReactorBlock.this));
            return this.found;
        }
    }
}

