/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fission;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.content.fission.FissionGasTank;
import mekanism.generators.common.content.fission.FissionInputGasTank;
import mekanism.generators.common.content.fission.FissionOutputGasTank;
import mekanism.generators.common.content.fission.FissionSteamTank;
import mekanism.generators.common.content.fission.FissionTank;
import mekanism.generators.common.content.fission.FissionWaterTank;
import mekanism.generators.common.content.fission.SynchronizedFissionData;
import mekanism.generators.common.tile.fission.TileEntityFissionCasing;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityFissionValve
extends TileEntityFissionCasing
implements IFluidHandlerWrapper,
IComputerIntegration,
IComparatorSupport,
IGasHandler,
IConfigurable {
    private static final String[] methods = new String[]{"isFormed", "getSteam", "getWater", "getBoilRate", "getMaxBoilRate", "getTemp"};
    public FissionTank waterTank = new FissionWaterTank(this);
    public FissionTank steamTank = new FissionSteamTank(this);
    public FissionGasTank inputTank = new FissionInputGasTank(this);
    public FissionGasTank outputTank = new FissionOutputGasTank(this);
    public boolean Eject;
    private int currentRedstoneLevel;

    public TileEntityFissionValve() {
        super("FissionValve");
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.Eject = nbtTags.func_74767_n("Eject");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74757_a("Eject", this.Eject);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.structure != null && ((SynchronizedFissionData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedFissionData)this.structure).upperRenderLocation.y - 1) {
            if (((SynchronizedFissionData)this.structure).steamStored != null && ((SynchronizedFissionData)this.structure).steamStored.amount > 0 && this.Eject) {
                EmitUtils.forEachSide(this.func_145831_w(), this.func_174877_v(), EnumSet.allOf(EnumFacing.class), (tile, side) -> {
                    IFluidHandler handler;
                    if (!(tile instanceof TileEntityFissionValve) && (handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) != null && PipeUtils.canFill(handler, ((SynchronizedFissionData)this.structure).steamStored)) {
                        ((SynchronizedFissionData)this.structure).steamStored.amount -= handler.fill(((SynchronizedFissionData)this.structure).steamStored, true);
                        if (((SynchronizedFissionData)this.structure).steamStored.amount <= 0) {
                            ((SynchronizedFissionData)this.structure).steamStored = null;
                        }
                    }
                });
            }
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> {
                if (this.outputTank.getGas() != null && this.outputTank.getGas().getGas() != null && this.Eject) {
                    GasStack toSend = this.outputTank.getGas().copy().withAmount(Math.min(this.outputTank.getMaxGas(), this.outputTank.getGasAmount()));
                    this.outputTank.output(GasUtils.emit(toSend, this, EnumSet.allOf(EnumFacing.class)), true);
                }
            });
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.updateComparatorOutputLevelSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            if (((SynchronizedFissionData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedFissionData)this.structure).upperRenderLocation.y - 1) {
                return new FluidTankInfo[]{this.steamTank.getInfo()};
            }
            return new FluidTankInfo[]{this.waterTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return new FluidTankInfo[]{this.steamTank.getInfo(), this.waterTank.getInfo()};
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.waterTank.fill(resource, doFill);
    }

    @Override
    @Nullable
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.steamTank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && !this.Eject) {
            return ((SynchronizedFissionData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() < ((SynchronizedFissionData)this.structure).upperRenderLocation.y - 1 && fluid.getFluid() == FluidRegistry.WATER;
        }
        return false;
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && this.Eject) {
            return ((SynchronizedFissionData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedFissionData)this.structure).upperRenderLocation.y - 1 && FluidContainerUtils.canDrain(((SynchronizedFissionData)this.structure).steamStored, fluid);
        }
        return false;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        if (method == 0) {
            return new Object[]{this.structure != null};
        }
        if (this.structure == null) {
            return new Object[]{"Unformed"};
        }
        switch (method) {
            case 1: {
                return new Object[]{((SynchronizedFissionData)this.structure).steamStored != null ? ((SynchronizedFissionData)this.structure).steamStored.amount : 0};
            }
            case 2: {
                return new Object[]{((SynchronizedFissionData)this.structure).waterStored != null ? ((SynchronizedFissionData)this.structure).waterStored.amount : 0};
            }
            case 3: {
                return new Object[]{((SynchronizedFissionData)this.structure).lastBoilRate};
            }
            case 4: {
                return new Object[]{((SynchronizedFissionData)this.structure).lastMaxBoil};
            }
            case 5: {
                return new Object[]{((SynchronizedFissionData)this.structure).temperature};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.CONFIGURABLE_CAPABILITY)) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            if (capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == Capabilities.GAS_HANDLER_CAPABILITY) {
                return (T)this;
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
            }
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.waterTank.getFluidAmount(), this.waterTank.getCapacity());
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return this.inputTank.input(stack, doTransfer);
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return this.outputTank.output(amount, doTransfer);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && !this.Eject) {
            return ((SynchronizedFissionData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() < ((SynchronizedFissionData)this.structure).upperRenderLocation.y - 1 && type == MekanismFluids.SuperheatedSodium;
        }
        return false;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && this.Eject) {
            return ((SynchronizedFissionData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedFissionData)this.structure).upperRenderLocation.y - 1 && GasUtils.canDrain(((SynchronizedFissionData)this.structure).OutputGas, type);
        }
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        GasTankInfo[] gasTankInfoArray;
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            GasTankInfo[] gasTankInfoArray2 = new GasTankInfo[2];
            gasTankInfoArray2[0] = this.inputTank.getInfo();
            gasTankInfoArray = gasTankInfoArray2;
            gasTankInfoArray2[1] = this.outputTank.getInfo();
        } else {
            gasTankInfoArray = IGasHandler.NONE;
        }
        return gasTankInfoArray;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            boolean prevEject = this.Eject;
            this.Eject = dataStream.readBoolean();
            if (prevEject != this.Eject) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.Eject);
        return data;
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K) {
            this.Eject = !this.Eject;
            String modeText = " " + (Object)((Object)(this.Eject ? EnumColor.DARK_RED : EnumColor.DARK_GREEN)) + LangUtils.transOutputInput(this.Eject) + ".";
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + " " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurator.reactorPortEject") + modeText));
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.markNoUpdateSync();
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }
}

