/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fission;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasStack;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.tile.multiblock.TileEntityMultiblock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fission.FissionCache;
import mekanism.generators.common.content.fission.FissionUpdateProtocol;
import mekanism.generators.common.content.fission.SynchronizedFissionData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityFissionCasing
extends TileEntityMultiblock<SynchronizedFissionData>
implements IHeatTransfer {
    protected static final int[] INV_SLOTS = new int[]{0, 1};
    public Set<SynchronizedTankData.ValveData> valveViewing = new ObjectOpenHashSet();
    public int clientWaterCapacity;
    public int clientSteamCapacity;
    public float prevWaterScale;

    public TileEntityFissionCasing() {
        super("FissionCasing");
    }

    public TileEntityFissionCasing(String name) {
        super(name);
        this.inventory = NonNullListSynchronized.withSize(INV_SLOTS.length, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            float targetScale;
            if (this.structure != null && this.clientHasStructure && this.isRendering && (double)Math.abs(this.prevWaterScale - (targetScale = (float)(((SynchronizedFissionData)this.structure).waterStored != null ? ((SynchronizedFissionData)this.structure).waterStored.amount : 0) / (float)this.clientWaterCapacity)) > 0.01) {
                this.prevWaterScale = (9.0f * this.prevWaterScale + targetScale) / 10.0f;
            }
            if (this.structure != null && this.clientHasStructure && this.isRendering && (double)Math.abs(this.prevWaterScale - (targetScale = (float)(((SynchronizedFissionData)this.structure).InputGas != null ? ((SynchronizedFissionData)this.structure).InputGas.amount : 0) / (float)this.clientWaterCapacity)) > 0.01) {
                this.prevWaterScale = (9.0f * this.prevWaterScale + targetScale) / 10.0f;
            }
            if (!this.clientHasStructure || !this.isRendering) {
                for (SynchronizedTankData.ValveData valveData : this.valveViewing) {
                    TileEntityFissionCasing tileEntity = (TileEntityFissionCasing)valveData.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = false;
                }
                this.valveViewing.clear();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.structure != null) {
            if (((SynchronizedFissionData)this.structure).waterStored != null && ((SynchronizedFissionData)this.structure).waterStored.amount <= 0) {
                ((SynchronizedFissionData)this.structure).waterStored = null;
                this.markNoUpdateSync();
            }
            if (((SynchronizedFissionData)this.structure).steamStored != null && ((SynchronizedFissionData)this.structure).steamStored.amount <= 0) {
                ((SynchronizedFissionData)this.structure).steamStored = null;
                this.markNoUpdateSync();
            }
            if (((SynchronizedFissionData)this.structure).InputGas != null && ((SynchronizedFissionData)this.structure).InputGas.amount <= 0) {
                ((SynchronizedFissionData)this.structure).InputGas = null;
                this.markNoUpdateSync();
            }
            if (((SynchronizedFissionData)this.structure).OutputGas != null && ((SynchronizedFissionData)this.structure).OutputGas.amount <= 0) {
                ((SynchronizedFissionData)this.structure).OutputGas = null;
                this.markNoUpdateSync();
            }
            if (this.isRendering) {
                int amountToBoil;
                double heatAvailable;
                boolean bl;
                boolean newHot;
                boolean needsValveUpdate = false;
                for (SynchronizedTankData.ValveData data : ((SynchronizedFissionData)this.structure).valves) {
                    if (data.activeTicks > 0) {
                        --data.activeTicks;
                    }
                    if (data.activeTicks > 0 != data.prevActive) {
                        needsValveUpdate = true;
                    }
                    data.prevActive = data.activeTicks > 0;
                }
                boolean bl2 = false;
                boolean bl3 = newHot = ((SynchronizedFissionData)this.structure).temperature >= SynchronizedFissionData.BASE_BOIL_TEMP - (double)0.01f;
                if (newHot != ((SynchronizedFissionData)this.structure).clientHot) {
                    bl = true;
                    ((SynchronizedFissionData)this.structure).clientHot = newHot;
                }
                double[] d = ((SynchronizedFissionData)this.structure).simulateHeat();
                ((SynchronizedFissionData)this.structure).applyTemperatureChange();
                ((SynchronizedFissionData)this.structure).lastEnvironmentLoss = d[1];
                if (((SynchronizedFissionData)this.structure).InputGas != null) {
                    int OutputAmount = ((SynchronizedFissionData)this.structure).OutputGas != null ? ((SynchronizedFissionData)this.structure).OutputGas.amount : 0;
                    heatAvailable = ((SynchronizedFissionData)this.structure).getTemp();
                    ((SynchronizedFissionData)this.structure).lastMaxBoil = (int)Math.floor(heatAvailable / SynchronizedFissionData.getHeatEnthalpy());
                    amountToBoil = Math.min(((SynchronizedFissionData)this.structure).lastMaxBoil, ((SynchronizedFissionData)this.structure).InputGas.amount);
                    amountToBoil = Math.min(amountToBoil, ((SynchronizedFissionData)this.structure).steamVolume * 160000 - OutputAmount);
                    ((SynchronizedFissionData)this.structure).InputGas.amount -= amountToBoil;
                    if (((SynchronizedFissionData)this.structure).OutputGas == null) {
                        ((SynchronizedFissionData)this.structure).OutputGas = new GasStack(MekanismFluids.Sodium, amountToBoil);
                    } else {
                        ((SynchronizedFissionData)this.structure).OutputGas.amount += amountToBoil;
                    }
                    if (((SynchronizedFissionData)this.structure).OutputGas.amount != ((SynchronizedFissionData)this.structure).steamVolume * 160000) {
                        ((SynchronizedFissionData)this.structure).temperature += (double)amountToBoil * SynchronizedFissionData.getHeatEnthalpy() / (double)((SynchronizedFissionData)this.structure).locations.size();
                        ((SynchronizedFissionData)this.structure).lastBoilRate = amountToBoil;
                    }
                }
                if (((SynchronizedFissionData)this.structure).temperature >= SynchronizedFissionData.BASE_BOIL_TEMP && ((SynchronizedFissionData)this.structure).waterStored != null) {
                    int steamAmount = ((SynchronizedFissionData)this.structure).steamStored != null ? ((SynchronizedFissionData)this.structure).steamStored.amount : 0;
                    heatAvailable = ((SynchronizedFissionData)this.structure).getHeatAvailable();
                    ((SynchronizedFissionData)this.structure).lastMaxBoil = (int)Math.floor(heatAvailable / SynchronizedFissionData.getHeatEnthalpy());
                    amountToBoil = Math.min(((SynchronizedFissionData)this.structure).lastMaxBoil, ((SynchronizedFissionData)this.structure).waterStored.amount);
                    amountToBoil = Math.min(amountToBoil, ((SynchronizedFissionData)this.structure).steamVolume * 160000 - steamAmount);
                    ((SynchronizedFissionData)this.structure).waterStored.amount -= amountToBoil;
                    if (((SynchronizedFissionData)this.structure).steamStored == null) {
                        ((SynchronizedFissionData)this.structure).steamStored = new FluidStack(FluidRegistry.getFluid((String)"steam"), amountToBoil);
                    } else {
                        ((SynchronizedFissionData)this.structure).steamStored.amount += amountToBoil;
                    }
                    ((SynchronizedFissionData)this.structure).temperature -= (double)amountToBoil * SynchronizedFissionData.getHeatEnthalpy() / (double)((SynchronizedFissionData)this.structure).locations.size();
                    ((SynchronizedFissionData)this.structure).lastBoilRate = amountToBoil;
                } else {
                    ((SynchronizedFissionData)this.structure).lastBoilRate = 0;
                    ((SynchronizedFissionData)this.structure).lastMaxBoil = 0;
                }
                if (needsValveUpdate || ((SynchronizedFissionData)this.structure).needsRenderUpdate() || bl) {
                    this.sendPacketToRenderer();
                }
                ((SynchronizedFissionData)this.structure).prevWater = ((SynchronizedFissionData)this.structure).waterStored != null ? ((SynchronizedFissionData)this.structure).waterStored.copy() : null;
                ((SynchronizedFissionData)this.structure).prevSteam = ((SynchronizedFissionData)this.structure).steamStored != null ? ((SynchronizedFissionData)this.structure).steamStored.copy() : null;
                ((SynchronizedFissionData)this.structure).prevInputGas = ((SynchronizedFissionData)this.structure).InputGas != null ? ((SynchronizedFissionData)this.structure).InputGas.copy() : null;
                ((SynchronizedFissionData)this.structure).prevOutputGas = ((SynchronizedFissionData)this.structure).OutputGas != null ? ((SynchronizedFissionData)this.structure).OutputGas.copy() : null;
                MekanismUtils.saveChunk(this);
            }
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.func_70093_af() && this.structure != null) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            player.openGui((Object)MekanismGenerators.instance, -1, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    protected SynchronizedFissionData getNewStructure() {
        return new SynchronizedFissionData();
    }

    public FissionCache getNewCache() {
        return new FissionCache();
    }

    protected FissionUpdateProtocol getProtocol() {
        return new FissionUpdateProtocol(this);
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add(((SynchronizedFissionData)this.structure).waterVolume * 16000);
            data.add(((SynchronizedFissionData)this.structure).steamVolume * 160000);
            data.add(((SynchronizedFissionData)this.structure).lastEnvironmentLoss);
            data.add(((SynchronizedFissionData)this.structure).lastBoilRate);
            data.add(((SynchronizedFissionData)this.structure).superheatingElements);
            data.add(((SynchronizedFissionData)this.structure).temperature);
            data.add(((SynchronizedFissionData)this.structure).lastMaxBoil);
            TileUtils.addFluidStack(data, ((SynchronizedFissionData)this.structure).waterStored);
            TileUtils.addFluidStack(data, ((SynchronizedFissionData)this.structure).steamStored);
            TileUtils.addGasStack(data, ((SynchronizedFissionData)this.structure).InputGas);
            TileUtils.addGasStack(data, ((SynchronizedFissionData)this.structure).OutputGas);
            ((SynchronizedFissionData)this.structure).upperRenderLocation.write(data);
            if (this.isRendering) {
                data.add(((SynchronizedFissionData)this.structure).clientHot);
                ObjectOpenHashSet toSend = new ObjectOpenHashSet();
                for (SynchronizedTankData.ValveData valveData : ((SynchronizedFissionData)this.structure).valves) {
                    if (valveData.activeTicks <= 0) continue;
                    toSend.add(valveData);
                }
                data.add(toSend.size());
                for (SynchronizedTankData.ValveData valveData : toSend) {
                    valveData.location.write(data);
                    data.add(valveData.side.ordinal());
                }
            }
        }
        return data;
    }

    @Override
    public MultiblockManager<SynchronizedFissionData> getManager() {
        return MekanismGenerators.fissionMangaer;
    }

    public double getLastEnvironmentLoss() {
        return this.structure != null ? ((SynchronizedFissionData)this.structure).lastEnvironmentLoss : 0.0;
    }

    public double getTemperature() {
        return this.structure != null ? ((SynchronizedFissionData)this.structure).temperature : 0.0;
    }

    public int getLastBoilRate() {
        return this.structure != null ? ((SynchronizedFissionData)this.structure).lastBoilRate : 0;
    }

    public int getLastMaxBoil() {
        return this.structure != null ? ((SynchronizedFissionData)this.structure).lastMaxBoil : 0;
    }

    public int getSuperheatingElements() {
        return this.structure != null ? ((SynchronizedFissionData)this.structure).superheatingElements : 0;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.clientHasStructure) {
            this.clientWaterCapacity = dataStream.readInt();
            this.clientSteamCapacity = dataStream.readInt();
            ((SynchronizedFissionData)this.structure).lastEnvironmentLoss = dataStream.readDouble();
            ((SynchronizedFissionData)this.structure).lastBoilRate = dataStream.readInt();
            ((SynchronizedFissionData)this.structure).superheatingElements = dataStream.readInt();
            ((SynchronizedFissionData)this.structure).temperature = dataStream.readDouble();
            ((SynchronizedFissionData)this.structure).lastMaxBoil = dataStream.readInt();
            ((SynchronizedFissionData)this.structure).waterStored = TileUtils.readFluidStack(dataStream);
            ((SynchronizedFissionData)this.structure).steamStored = TileUtils.readFluidStack(dataStream);
            ((SynchronizedFissionData)this.structure).InputGas = TileUtils.readGasStack(dataStream);
            ((SynchronizedFissionData)this.structure).OutputGas = TileUtils.readGasStack(dataStream);
            ((SynchronizedFissionData)this.structure).upperRenderLocation = Coord4D.read(dataStream);
            if (this.isRendering) {
                ((SynchronizedFissionData)this.structure).clientHot = dataStream.readBoolean();
                SynchronizedFissionData.clientHotMap.put(((SynchronizedFissionData)this.structure).inventoryID, ((SynchronizedFissionData)this.structure).clientHot);
                int size = dataStream.readInt();
                this.valveViewing.clear();
                for (int i = 0; i < size; ++i) {
                    SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
                    data.location = Coord4D.read(dataStream);
                    data.side = EnumFacing.func_82600_a((int)dataStream.readInt());
                    this.valveViewing.add(data);
                    TileEntityFissionCasing tileEntity = (TileEntityFissionCasing)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = true;
                }
            }
        }
    }

    @Override
    public double getTemp() {
        return 0.0;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return SynchronizedFissionData.CASING_INVERSE_CONDUCTION_COEFFICIENT;
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return SynchronizedFissionData.CASING_INSULATION_COEFFICIENT;
    }

    @Override
    public void transferHeatTo(double heat) {
        if (this.structure != null) {
            ((SynchronizedFissionData)this.structure).heatToAbsorb += heat;
        }
    }

    @Override
    public double[] simulateHeat() {
        return new double[]{0.0, 0.0};
    }

    @Override
    public double applyTemperatureChange() {
        return 0.0;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return this.structure != null;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.HEAT_TRANSFER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)Capabilities.HEAT_TRANSFER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize("gui.fissionReactor");
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }
}

