/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityWindGenerator
extends TileEntityGenerator
implements IBoundingBlock {
    public static final float SPEED = 32.0f;
    public static final float SPEED_SCALED = 8.0f;
    static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getMultiplier"};
    private static final int[] SLOTS = new int[]{0};
    private double angle;
    private float currentMultiplier;
    private boolean isBlacklistDimension = false;

    public TileEntityWindGenerator() {
        super("wind", "WindGenerator", MekanismConfig.current().generators.windGeneratorStorage.val(), MekanismConfig.current().generators.windGenerationMax.val() * 2.0);
        this.inventory = NonNullListSynchronized.withSize(SLOTS.length, ItemStack.field_190927_a);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.isBlacklistDimension = MekanismConfig.current().generators.windGenerationDimBlacklist.val().contains(this.field_145850_b.field_73011_w.getDimension());
        if (this.isBlacklistDimension) {
            this.setActive(false);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge(0, (IStrictEnergyStorage)this);
            if (this.isBlacklistDimension) {
                return;
            }
            if (this.ticker % 20 == 0) {
                this.currentMultiplier = this.getMultiplier();
                this.setActive(MekanismUtils.canFunction(this) && this.currentMultiplier > 0.0f);
            }
            if (this.getActive()) {
                this.setEnergy(this.electricityStored.get() + MekanismConfig.current().generators.windGenerationMin.val() * (double)this.currentMultiplier);
            }
        } else if (this.getActive()) {
            this.angle = (this.angle + (double)(((float)this.func_174877_v().func_177956_o() + 4.0f) / 8.0f)) % 360.0;
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.currentMultiplier = dataStream.readFloat();
            this.isBlacklistDimension = dataStream.readBoolean();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(Float.valueOf(this.currentMultiplier));
        data.add(this.isBlacklistDimension);
        return data;
    }

    public float getMultiplier() {
        BlockPos top = this.func_174877_v().func_177981_b(4);
        if (this.field_145850_b.func_175678_i(top)) {
            int minY = MekanismConfig.current().generators.windGenerationMinY.val();
            int maxY = MekanismConfig.current().generators.windGenerationMaxY.val();
            float clampedY = Math.min(maxY, Math.max(minY, top.func_177956_o()));
            float minG = (float)MekanismConfig.current().generators.windGenerationMin.val();
            float maxG = (float)MekanismConfig.current().generators.windGenerationMax.val();
            int rangeY = maxY < minY ? minY - maxY : maxY - minY;
            float rangG = maxG < minG ? minG - maxG : maxG - minG;
            float slope = rangG / (float)rangeY;
            float toGen = minG + slope * (clampedY - (float)minY);
            return toGen / minG;
        }
        return 0.0f;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.electricityStored;
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.output;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.BASE_MAX_ENERGY;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.BASE_MAX_ENERGY - this.electricityStored.get();
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = Float.valueOf(this.getMultiplier());
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored.get() < this.BASE_MAX_ENERGY && this.getMultiplier() > 0.0f && MekanismUtils.canFunction(this);
    }

    @Override
    public void onPlace() {
        Coord4D current = Coord4D.get(this);
        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177967_a(EnumFacing.UP, 1), current);
        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177967_a(EnumFacing.UP, 2), current);
        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177967_a(EnumFacing.UP, 3), current);
        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177967_a(EnumFacing.UP, 4), current);
        this.isBlacklistDimension = MekanismConfig.current().generators.windGenerationDimBlacklist.val().contains(this.field_145850_b.field_73011_w.getDimension());
    }

    @Override
    public void onBreak() {
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, 1, 0));
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, 2, 0));
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, 3, 0));
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, 4, 0));
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    public float getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean isBlacklistDimension() {
        return this.isBlacklistDimension;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return SLOTS;
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return ChargeUtils.canBeCharged(stack);
    }
}

