/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.FluidTankSync;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TileUtils;
import mekanism.generators.client.render.bloom.BloomRenderHeatGenerator;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityHeatGenerator
extends TileEntityGenerator
implements IFluidHandlerWrapper,
ISustainedData,
IHeatTransfer,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getFuel", "getFuelNeeded"};
    public FluidTank lavaTank = new FluidTankSync(24000);
    public double temperature = 0.0;
    public double thermalEfficiency = 0.5;
    public double invHeatCapacity = 1.0;
    public double heatToAbsorb = 0.0;
    public double producingEnergy;
    public double lastTransferLoss;
    public double lastEnvironmentLoss;
    private int currentRedstoneLevel;
    private boolean rendererInitialized = false;

    public TileEntityHeatGenerator() {
        super("heat", "HeatGenerator", MekanismConfig.current().generators.heatGeneratorStorage.val(), MekanismConfig.current().generators.heatGeneration.val() * 2.0);
        this.inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge(1, (IStrictEnergyStorage)this);
            if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
                if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0))) {
                    this.lavaTank.fill(FluidContainerUtils.extractFluid(this.lavaTank, this, 0, FluidContainerUtils.FluidChecker.check(FluidRegistry.LAVA)), true);
                } else {
                    int fuelNeeded;
                    int fuel = this.getFuel((ItemStack)this.inventory.get(0));
                    if (fuel > 0 && fuel <= (fuelNeeded = this.lavaTank.getCapacity() - (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0))) {
                        this.lavaTank.fill(new FluidStack(FluidRegistry.LAVA, fuel), true);
                        if (!((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)).func_190926_b()) {
                            this.inventory.set(0, ((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)));
                        } else {
                            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                        }
                    }
                }
            }
            double prev = this.getEnergy();
            this.transferHeatTo(this.getBoost());
            if (this.canOperate()) {
                this.setActive(true);
                this.lavaTank.drain(10, true);
                this.transferHeatTo(MekanismConfig.current().generators.heatGeneration.val());
            } else {
                this.setActive(false);
            }
            double[] loss = this.simulateHeat();
            this.applyTemperatureChange();
            this.lastTransferLoss = loss[0];
            this.lastEnvironmentLoss = loss[1];
            this.producingEnergy = this.getEnergy() - prev;
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.updateComparatorOutputLevelSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            if (this.getFuel(itemstack) > 0) {
                return true;
            }
            FluidStack fluidContained = FluidUtil.getFluidContained((ItemStack)itemstack);
            return fluidContained != null && fluidContained.getFluid() == FluidRegistry.LAVA;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored.get() < this.BASE_MAX_ENERGY && this.lavaTank.getFluid() != null && this.lavaTank.getFluid().amount >= 10 && MekanismUtils.canFunction(this);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        if (nbtTags.func_74764_b("lavaTank")) {
            this.lavaTank.readFromNBT(nbtTags.func_74775_l("lavaTank"));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        if (this.lavaTank.getFluid() != null) {
            nbtTags.func_74782_a("lavaTank", (NBTBase)this.lavaTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, true);
        }
        if (slotID == 0) {
            return FluidUtil.getFluidContained((ItemStack)itemstack) == null;
        }
        return false;
    }

    public double getBoost() {
        int lavaBoost = 0;
        double netherBoost = 0.0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Coord4D coord = Coord4D.get(this).offset(side);
            if (!this.isLava(coord.getPos())) continue;
            ++lavaBoost;
        }
        if (this.field_145850_b.field_73011_w.getDimension() == -1) {
            netherBoost = MekanismConfig.current().generators.heatGenerationNether.val();
        }
        return MekanismConfig.current().generators.heatGenerationLava.val() * (double)lavaBoost + netherBoost;
    }

    private boolean isLava(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l;
    }

    public int getFuel(ItemStack itemstack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack) / 2;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        int[] nArray;
        if (side == MekanismUtils.getRight(this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public int getScaledFuelLevel(int i) {
        return (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0) * i / this.lavaTank.getCapacity();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.producingEnergy = dataStream.readDouble();
            this.lastTransferLoss = dataStream.readDouble();
            this.lastEnvironmentLoss = dataStream.readDouble();
            TileUtils.readTankData(dataStream, this.lavaTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.producingEnergy);
        data.add(this.lastTransferLoss);
        data.add(this.lastEnvironmentLoss);
        TileUtils.addTankData(data, this.lavaTank);
        return data;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.electricityStored;
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.output;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.BASE_MAX_ENERGY;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.BASE_MAX_ENERGY - this.electricityStored.get();
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0;
                break;
            }
            case 5: {
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = this.lavaTank.getCapacity() - (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0);
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.lavaTank.fill(resource, doFill);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        return fluid.getFluid().equals(FluidRegistry.LAVA) && from != this.facing;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from == this.facing) {
            return PipeUtils.EMPTY;
        }
        return new FluidTankInfo[]{this.lavaTank.getInfo()};
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.lavaTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "lavaTank", this.lavaTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.lavaTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "lavaTank")));
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 1.0;
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return this.canConnectHeat(side) ? 0.0 : 10000.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        if (this.getTemp() > 0.0) {
            double carnotEfficiency = this.getTemp() / (this.getTemp() + 300.0);
            double heatLost = this.thermalEfficiency * this.getTemp();
            double workDone = heatLost * carnotEfficiency;
            this.transferHeatTo(-heatLost);
            this.setEnergy(this.getEnergy() + workDone);
        }
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.invHeatCapacity * this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        TileEntity adj;
        if (this.canConnectHeat(side) && CapabilityUtils.hasCapability((ICapabilityProvider)(adj = Coord4D.get(this).offset(side).getTileEntity((IBlockAccess)this.field_145850_b)), Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.HEAT_TRANSFER_CAPABILITY || side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)Capabilities.HEAT_TRANSFER_CAPABILITY.cast((Object)this);
        }
        if (side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.lavaTank.getFluidAmount(), this.lavaTank.getCapacity());
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K && !this.rendererInitialized) {
            this.rendererInitialized = true;
            if (Mekanism.hooks.Bloom && MekanismConfig.current().client.enableBloom.val()) {
                new BloomRenderHeatGenerator(this);
            }
        }
    }

    @Override
    public boolean supportsAsync() {
        return false;
    }
}

