/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.FuelHandler;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.ISustainedData;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityGasGenerator
extends TileEntityGenerator
implements IGasHandler,
ISustainedData,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getGas", "getGasNeeded"};
    public int MAX_GAS = 18000;
    public GasTank fuelTank;
    public int burnTicks = 0;
    public int maxBurnTicks;
    public double generationRate = 0.0;
    public int clientUsed;
    private int currentRedstoneLevel;

    public TileEntityGasGenerator() {
        super("gas", "GasGenerator", MekanismConfig.current().general.FROM_H2.val() * 100.0, MekanismConfig.current().general.FROM_H2.val() * 2.0);
        this.inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
        this.fuelTank = new GasTank(this.MAX_GAS);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            boolean operate;
            ChargeUtils.charge(1, (IStrictEnergyStorage)this);
            if (!((ItemStack)this.inventory.get(0)).func_190926_b() && this.fuelTank.getStored() < this.MAX_GAS) {
                IGasItem gasItem;
                Item item;
                Gas gasType = null;
                if (this.fuelTank.getGas() != null) {
                    gasType = this.fuelTank.getGas().getGas();
                } else if (!((ItemStack)this.inventory.get(0)).func_190926_b() && (item = ((ItemStack)this.inventory.get(0)).func_77973_b()) instanceof IGasItem && (gasItem = (IGasItem)item).getGas((ItemStack)this.inventory.get(0)) != null) {
                    gasType = gasItem.getGas((ItemStack)this.inventory.get(0)).getGas();
                }
                if (gasType != null && FuelHandler.getFuel(gasType) != null) {
                    GasStack removed = GasUtils.removeGas((ItemStack)this.inventory.get(0), gasType, this.fuelTank.getNeeded());
                    boolean isTankEmpty = this.fuelTank.getGas() == null;
                    int fuelReceived = this.fuelTank.receive(removed, true);
                    if (fuelReceived > 0 && isTankEmpty) {
                        this.output = FuelHandler.getFuel((Gas)this.fuelTank.getGas().getGas()).energyPerTick * 2.0;
                    }
                }
            }
            if ((operate = this.canOperate()) && this.getEnergy() + this.generationRate < this.getMaxEnergy()) {
                this.setActive(true);
                if (this.fuelTank.getStored() != 0) {
                    FuelHandler.FuelGas fuel = FuelHandler.getFuel(this.fuelTank.getGas().getGas());
                    this.maxBurnTicks = fuel.burnTicks;
                    this.generationRate = fuel.energyPerTick;
                }
                int toUse = this.getToUse();
                this.output = Math.max(MekanismConfig.current().general.FROM_H2.val() * 2.0, this.generationRate * (double)this.getToUse() * 2.0);
                int total = this.burnTicks + this.fuelTank.getStored() * this.maxBurnTicks;
                total -= toUse;
                this.setEnergy(this.getEnergy() + this.generationRate * (double)toUse);
                if (this.fuelTank.getStored() > 0) {
                    this.fuelTank.setGas(new GasStack(this.fuelTank.getGasType(), total / this.maxBurnTicks));
                }
                this.burnTicks = total % this.maxBurnTicks;
                this.clientUsed = toUse;
            } else {
                if (!operate) {
                    this.reset();
                }
                this.clientUsed = 0;
                this.setActive(false);
            }
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.updateComparatorOutputLevelSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    public void reset() {
        this.burnTicks = 0;
        this.maxBurnTicks = 0;
        this.generationRate = 0.0;
        this.output = MekanismConfig.current().general.FROM_H2.val() * 2.0;
    }

    public int getToUse() {
        if (this.generationRate == 0.0 || this.fuelTank.getGas() == null) {
            return 0;
        }
        int max = (int)Math.ceil((float)this.fuelTank.getStored() / (float)this.fuelTank.getMaxGas() * 256.0f);
        max = Math.min(this.fuelTank.getStored() * this.maxBurnTicks + this.burnTicks, max);
        max = (int)Math.min((this.getMaxEnergy() - this.getEnergy()) / this.generationRate, (double)max);
        return max;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, true);
        }
        if (slotID == 0) {
            IGasItem gasItem;
            Item item = itemstack.func_77973_b();
            return item instanceof IGasItem && (gasItem = (IGasItem)item).getGas(itemstack) == null;
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            IGasItem gasItem;
            Item item = itemstack.func_77973_b();
            return item instanceof IGasItem && (gasItem = (IGasItem)item).getGas(itemstack) != null && FuelHandler.getFuel(gasItem.getGas(itemstack).getGas()) != null;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        return true;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        int[] nArray;
        if (side == MekanismUtils.getRight(this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    @Override
    public boolean canOperate() {
        return (this.fuelTank.getStored() > 0 || this.burnTicks > 0) && MekanismUtils.canFunction(this);
    }

    public int getScaledGasLevel(int i) {
        return this.fuelTank.getStored() * i / this.MAX_GAS;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getEnergy();
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.output;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.getMaxEnergy();
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.getMaxEnergy() - this.getEnergy();
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = this.fuelTank.getStored();
                break;
            }
            case 5: {
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = this.fuelTank.getNeeded();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.fuelTank);
            this.generationRate = dataStream.readDouble();
            this.output = dataStream.readDouble();
            this.clientUsed = dataStream.readInt();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.fuelTank);
        data.add(this.generationRate);
        data.add(this.output);
        data.add(this.clientUsed);
        return data;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        boolean isTankEmpty;
        boolean bl = isTankEmpty = this.fuelTank.getGas() == null;
        if (this.canReceiveGas(side, stack.getGas()) && (isTankEmpty || this.fuelTank.getGas().isGasEqual(stack))) {
            int fuelReceived = this.fuelTank.receive(stack, doTransfer);
            if (doTransfer && isTankEmpty && fuelReceived > 0) {
                this.output = FuelHandler.getFuel((Gas)this.fuelTank.getGas().getGas()).energyPerTick * 2.0;
            }
            return fuelReceived;
        }
        return 0;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.fuelTank};
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        FuelHandler.FuelGas fuel;
        super.readCustomNBT(nbtTags);
        this.fuelTank.read(nbtTags.func_74775_l("fuelTank"));
        boolean isTankEmpty = this.fuelTank.getGas() == null;
        FuelHandler.FuelGas fuelGas = fuel = isTankEmpty ? null : FuelHandler.getFuel(this.fuelTank.getGas().getGas());
        if (fuel != null) {
            this.output = fuel.energyPerTick * 2.0;
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("fuelTank", (NBTBase)this.fuelTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return FuelHandler.getFuel(type) != null && side != this.facing;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return side == this.facing;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fuelTank != null) {
            ItemDataUtils.setCompound(itemStack, "fuelTank", this.fuelTank.write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "fuelTank")) {
            FuelHandler.FuelGas fuel;
            this.fuelTank.read(ItemDataUtils.getCompound(itemStack, "fuelTank"));
            boolean isTankEmpty = this.fuelTank.getGas() == null;
            FuelHandler.FuelGas fuelGas = fuel = isTankEmpty ? null : FuelHandler.getFuel(this.fuelTank.getGas().getGas());
            if (fuel != null) {
                this.output = fuel.energyPerTick * 2.0;
            }
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fuelTank.getStored(), this.fuelTank.getMaxGas());
    }
}

