/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.FluidSlot;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityBioGenerator
extends TileEntityGenerator
implements IFluidHandlerWrapper,
ISustainedData,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getBioFuel", "getBioFuelNeeded"};
    private static FluidTankInfo[] ALL_TANKS = new FluidTankInfo[0];
    public FluidSlot bioFuelSlot = new FluidSlot(24000, -1);
    private int lastBioFuelAmount;
    private int currentRedstoneLevel;
    public int updateDelay;
    public boolean needsPacket;

    public TileEntityBioGenerator() {
        super("bio", "BioGenerator", MekanismConfig.current().generators.bioGeneratorStorage.val(), MekanismConfig.current().generators.bioGeneration.val() * 2.0);
        this.inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    this.needsPacket = true;
                }
            }
            ChargeUtils.charge(1, (IStrictEnergyStorage)this);
            if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
                FluidStack fluid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.inventory.get(0)));
                if (fluid != null && FluidRegistry.isFluidRegistered((String)"bioethanol")) {
                    IFluidHandlerItem handler;
                    FluidStack drained;
                    if (fluid.getFluid() == FluidRegistry.getFluid((String)"bioethanol") && (drained = (handler = FluidUtil.getFluidHandler((ItemStack)((ItemStack)this.inventory.get(0)))).drain(this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored, true)) != null) {
                        this.bioFuelSlot.fluidStored += drained.amount;
                    }
                } else {
                    int fuelNeeded;
                    int fuel = this.getFuel((ItemStack)this.inventory.get(0));
                    if (fuel > 0 && fuel <= (fuelNeeded = this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored)) {
                        this.bioFuelSlot.fluidStored += fuel;
                        if (!((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)).func_190926_b()) {
                            this.inventory.set(0, ((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)));
                        } else {
                            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                        }
                    }
                }
            }
            if (this.canOperate()) {
                this.setActive(true);
                this.bioFuelSlot.setFluid(this.bioFuelSlot.fluidStored - 1);
                this.setEnergy(this.electricityStored.get() + MekanismConfig.current().generators.bioGeneration.val());
            } else {
                this.setActive(false);
            }
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.updateComparatorOutputLevelSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
            if (this.needsPacket) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            this.needsPacket = false;
            if (this.lastBioFuelAmount != this.bioFuelSlot.fluidStored) {
                SPacketUpdateTileEntity packet = this.func_189518_D_();
                PlayerChunkMapEntry trackingEntry = ((WorldServer)this.field_145850_b).func_184164_w().func_187301_b(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                if (trackingEntry != null) {
                    for (EntityPlayerMP player : trackingEntry.getWatchingPlayers()) {
                        player.field_71135_a.func_147359_a((Packet)packet);
                    }
                }
            }
            this.lastBioFuelAmount = this.bioFuelSlot.fluidStored;
        } else if (this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            FluidStack fluidContained;
            if (this.getFuel(itemstack) > 0) {
                return true;
            }
            if (FluidRegistry.isFluidRegistered((String)"bioethanol") && (fluidContained = FluidUtil.getFluidContained((ItemStack)itemstack)) != null) {
                return fluidContained.getFluid() == FluidRegistry.getFluid((String)"bioethanol");
            }
            return false;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored.get() < this.BASE_MAX_ENERGY && this.bioFuelSlot.fluidStored > 0 && MekanismUtils.canFunction(this);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.bioFuelSlot.fluidStored = nbtTags.func_74762_e("bioFuelStored");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("bioFuelStored", this.bioFuelSlot.fluidStored);
    }

    public int getFuel(ItemStack itemstack) {
        return itemstack.func_77973_b() == MekanismItems.BioFuel ? 200 : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.bioFuelSlot.fluidStored * i / this.bioFuelSlot.MAX_FLUID;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        int[] nArray;
        if (side == MekanismUtils.getRight(this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return super.canSetFacing(facing);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.bioFuelSlot.fluidStored = dataStream.readInt();
            if (this.updateDelay == 0) {
                this.updateDelay = MekanismConfig.current().general.UPDATE_DELAY.val();
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.updateDelay == 0) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.updateDelay = 10;
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.bioFuelSlot.fluidStored);
        return data;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.electricityStored;
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.output;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.BASE_MAX_ENERGY;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.BASE_MAX_ENERGY - this.electricityStored.get();
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = this.bioFuelSlot.fluidStored;
                break;
            }
            case 5: {
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored;
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        int fuelNeeded = this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored;
        int fuelTransfer = Math.min(resource.amount, fuelNeeded);
        if (doFill) {
            this.bioFuelSlot.setFluid(this.bioFuelSlot.fluidStored + fuelTransfer);
        }
        return fuelTransfer;
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        return from != this.facing && fluid.getFluid() == FluidRegistry.getFluid((String)"bioethanol");
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return PipeUtils.EMPTY;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setInt(itemStack, "fluidStored", this.bioFuelSlot.fluidStored);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.bioFuelSlot.setFluid(ItemDataUtils.getInt(itemStack, "fluidStored"));
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return ALL_TANKS;
    }

    @Override
    public int getRedstoneLevel() {
        return Container.func_94526_b((IInventory)this);
    }
}

