/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.content.tank.TankUpdateProtocol;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.block.states.BlockStateGenerator;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.content.turbine.TurbineCache;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TurbineUpdateProtocol
extends UpdateProtocol<SynchronizedTurbineData> {
    public static final int FLUID_PER_TANK = TankUpdateProtocol.FLUID_PER_TANK;
    public static final int MAX_BLADES = 28;

    public TurbineUpdateProtocol(TileEntityTurbineCasing tileEntity) {
        super(tileEntity);
    }

    @Override
    protected boolean isValidFrame(int x, int y, int z) {
        return BlockStateGenerator.GeneratorType.get(this.pointer.func_145831_w().func_180495_p(new BlockPos(x, y, z))) == BlockStateGenerator.GeneratorType.TURBINE_CASING;
    }

    @Override
    protected boolean isValidInnerNode(int x, int y, int z) {
        if (super.isValidInnerNode(x, y, z)) {
            return true;
        }
        TileEntity tile = this.pointer.func_145831_w().func_175625_s(new BlockPos(x, y, z));
        return tile instanceof TileEntityTurbineRotor || tile instanceof TileEntityRotationalComplex || tile instanceof TileEntityPressureDisperser || tile instanceof TileEntityElectromagneticCoil || tile instanceof TileEntitySaturatingCondenser;
    }

    @Override
    protected boolean canForm(SynchronizedTurbineData structure) {
        TileEntity tile;
        if (structure.volLength % 2 != 1 || structure.volWidth % 2 != 1) {
            return false;
        }
        int innerRadius = (Math.min(structure.volLength, structure.volWidth) - 3) / 2;
        if ((double)innerRadius < Math.ceil((structure.volHeight - 2) / 4)) {
            return false;
        }
        int centerX = structure.minLocation.x + (structure.volLength - 1) / 2;
        int centerZ = structure.minLocation.z + (structure.volWidth - 1) / 2;
        Coord4D complex = null;
        ObjectOpenHashSet turbines = new ObjectOpenHashSet();
        ObjectOpenHashSet dispersers = new ObjectOpenHashSet();
        ObjectOpenHashSet coils = new ObjectOpenHashSet();
        ObjectOpenHashSet condensers = new ObjectOpenHashSet();
        for (Coord4D coord : this.innerNodes) {
            tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (tile instanceof TileEntityRotationalComplex) {
                if (complex != null || coord.x != centerX || coord.z != centerZ) {
                    return false;
                }
                structure.internalLocations.add(coord);
                complex = coord;
                continue;
            }
            if (tile instanceof TileEntityTurbineRotor) {
                if (coord.x != centerX || coord.z != centerZ) {
                    return false;
                }
                turbines.add(coord);
                continue;
            }
            if (tile instanceof TileEntityPressureDisperser) {
                dispersers.add(coord);
                continue;
            }
            if (tile instanceof TileEntityElectromagneticCoil) {
                coils.add(coord);
                continue;
            }
            if (!(tile instanceof TileEntitySaturatingCondenser)) continue;
            condensers.add(coord);
        }
        if (complex == null) {
            return false;
        }
        for (int x = complex.x - innerRadius; x <= complex.x + innerRadius; ++x) {
            for (int z = complex.z - innerRadius; z <= complex.z + innerRadius; ++z) {
                if (x == centerX && z == centerZ) continue;
                tile = this.pointer.func_145831_w().func_175625_s(new BlockPos(x, complex.y, z));
                if (!(tile instanceof TileEntityPressureDisperser)) {
                    return false;
                }
                dispersers.remove(new Coord4D(x, complex.y, z, this.pointer.func_145831_w().field_73011_w.getDimension()));
            }
        }
        if (!dispersers.isEmpty()) {
            return false;
        }
        for (Coord4D coord : condensers) {
            if (coord.y > complex.y) continue;
            return false;
        }
        structure.condensers = condensers.size();
        int turbineHeight = 0;
        int blades = 0;
        for (int y = complex.y - 1; y > structure.minLocation.y; --y) {
            TileEntity tile2 = this.pointer.func_145831_w().func_175625_s(new BlockPos(centerX, y, centerZ));
            if (tile2 instanceof TileEntityTurbineRotor) {
                TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)tile2;
                ++turbineHeight;
                blades += rotor.getHousedBlades();
            } else {
                return false;
            }
            structure.internalLocations.add(Coord4D.get(tile2));
            turbines.remove(new Coord4D(centerX, y, centerZ, this.pointer.func_145831_w().field_73011_w.getDimension()));
        }
        if (!turbines.isEmpty()) {
            return false;
        }
        structure.blades = blades;
        Coord4D startCoord = complex.offset(EnumFacing.UP);
        if (startCoord.getTileEntity((IBlockAccess)this.pointer.func_145831_w()) instanceof TileEntityElectromagneticCoil) {
            structure.coils = new UpdateProtocol.NodeCounter(new UpdateProtocol.NodeChecker(){

                @Override
                public boolean isValid(Coord4D coord) {
                    return coord.getTileEntity((IBlockAccess)TurbineUpdateProtocol.this.pointer.func_145831_w()) instanceof TileEntityElectromagneticCoil;
                }
            }).calculate(startCoord);
        }
        if (coils.size() > structure.coils) {
            return false;
        }
        for (Coord4D coord : structure.locations) {
            if (!(coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w()) instanceof TileEntityTurbineVent)) continue;
            if (coord.y < complex.y) {
                return false;
            }
            ++structure.vents;
        }
        structure.lowerVolume = structure.volLength * structure.volWidth * turbineHeight;
        structure.complex = complex;
        return true;
    }

    @Override
    protected MultiblockCache<SynchronizedTurbineData> getNewCache() {
        return new TurbineCache();
    }

    @Override
    protected SynchronizedTurbineData getNewStructure() {
        return new SynchronizedTurbineData();
    }

    @Override
    protected MultiblockManager<SynchronizedTurbineData> getManager() {
        return MekanismGenerators.turbineManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedTurbineData> cache, MultiblockCache<SynchronizedTurbineData> merge) {
        TurbineCache turbineCache = (TurbineCache)cache;
        TurbineCache mergeCache = (TurbineCache)merge;
        if (turbineCache.fluid == null) {
            turbineCache.fluid = mergeCache.fluid;
        } else if (mergeCache.fluid != null && turbineCache.fluid.isFluidEqual(mergeCache.fluid)) {
            turbineCache.fluid.amount += mergeCache.fluid.amount;
        }
        turbineCache.electricity += mergeCache.electricity;
        turbineCache.dumpMode = mergeCache.dumpMode;
    }

    @Override
    protected void onFormed() {
        super.onFormed();
        if (((SynchronizedTurbineData)this.structureFound).fluidStored != null) {
            ((SynchronizedTurbineData)this.structureFound).fluidStored.amount = Math.min(((SynchronizedTurbineData)this.structureFound).fluidStored.amount, ((SynchronizedTurbineData)this.structureFound).getFluidCapacity());
        }
        ((SynchronizedTurbineData)this.structureFound).electricityStored = Math.min(((SynchronizedTurbineData)this.structureFound).electricityStored, ((SynchronizedTurbineData)this.structureFound).getEnergyCapacity());
    }
}

