/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.common.config.MekanismConfig;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.generators.common.content.turbine.TurbineUpdateProtocol;
import net.minecraftforge.fluids.FluidStack;

public class SynchronizedTurbineData
extends SynchronizedData<SynchronizedTurbineData> {
    public static final float ROTATION_THRESHOLD = 0.001f;
    public static Map<String, Float> clientRotationMap = new Object2ObjectOpenHashMap();
    @Nullable
    public FluidStack fluidStored;
    @Nullable
    public FluidStack prevFluid;
    public double electricityStored;
    public TileEntityGasTank.GasMode dumpMode = TileEntityGasTank.GasMode.IDLE;
    public int blades;
    public int vents;
    public int coils;
    public int condensers;
    public int lowerVolume;
    public Coord4D complex;
    public int lastSteamInput;
    public int newSteamInput;
    public int flowRemaining;
    public int clientDispersers;
    public int clientFlow;
    public float clientRotation;

    public int getDispersers() {
        return (this.volLength - 2) * (this.volWidth - 2) - 1;
    }

    public int getFluidCapacity() {
        return this.lowerVolume * TurbineUpdateProtocol.FLUID_PER_TANK;
    }

    public double getEnergyCapacity() {
        return (double)this.volume * MekanismConfig.current().generators.turbineGeneratorStorage.val();
    }

    public boolean needsRenderUpdate() {
        if (this.fluidStored == null && this.prevFluid != null || this.fluidStored != null && this.prevFluid == null) {
            return true;
        }
        if (this.fluidStored != null) {
            return this.fluidStored.getFluid() != this.prevFluid.getFluid() || this.fluidStored.amount != this.prevFluid.amount;
        }
        return false;
    }
}

