/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fission;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fission.FissionCache;
import mekanism.generators.common.content.fission.SynchronizedFissionData;
import mekanism.generators.common.tile.fission.TileEntityControlRodAssembly;
import mekanism.generators.common.tile.fission.TileEntityFissionCasing;
import mekanism.generators.common.tile.fission.TileEntityFissionFuelAssembly;
import mekanism.generators.common.tile.fission.TileEntityFissionValve;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class FissionUpdateProtocol
extends UpdateProtocol<SynchronizedFissionData> {
    public static final int WATER_PER_TANK = 16000;
    public static final int STEAM_PER_TANK = 160000;

    public FissionUpdateProtocol(TileEntityFissionCasing tileEntity) {
        super(tileEntity);
    }

    @Override
    protected boolean isValidFrame(int x, int y, int z) {
        return false;
    }

    @Override
    protected boolean isValidInnerNode(int x, int y, int z) {
        if (super.isValidInnerNode(x, y, z)) {
            return true;
        }
        TileEntity tile = this.pointer.func_145831_w().func_175625_s(new BlockPos(x, y, z));
        return tile instanceof TileEntityFissionFuelAssembly || tile instanceof TileEntityControlRodAssembly;
    }

    @Override
    protected boolean canForm(SynchronizedFissionData structure) {
        if (structure.volHeight < 3) {
            return false;
        }
        ObjectOpenHashSet dispersers = new ObjectOpenHashSet();
        ObjectOpenHashSet elements = new ObjectOpenHashSet();
        for (Coord4D coord : this.innerNodes) {
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (tile instanceof TileEntityControlRodAssembly) {
                dispersers.add(coord);
                continue;
            }
            if (!(tile instanceof TileEntityFissionFuelAssembly)) continue;
            structure.internalLocations.add(coord);
            elements.add(coord);
        }
        if (dispersers.isEmpty()) {
            return false;
        }
        final Coord4D initDisperser = (Coord4D)dispersers.iterator().next();
        Coord4D pos = new Coord4D(structure.renderLocation.x, initDisperser.y, structure.renderLocation.z, this.pointer.func_145831_w().field_73011_w.getDimension());
        for (int x = 1; x < structure.volLength - 1; ++x) {
            for (int z = 1; z < structure.volWidth - 1; ++z) {
                Coord4D coord4D = pos.translate(x, 0, z);
                TileEntity tile = coord4D.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (!(tile instanceof TileEntityControlRodAssembly)) {
                    return false;
                }
                dispersers.remove(coord4D);
            }
        }
        if (!dispersers.isEmpty()) {
            return false;
        }
        if (elements.size() > 0) {
            structure.superheatingElements = new UpdateProtocol.NodeCounter(new UpdateProtocol.NodeChecker(){

                @Override
                public boolean isValid(Coord4D coord) {
                    return coord.getTileEntity((IBlockAccess)FissionUpdateProtocol.this.pointer.func_145831_w()) instanceof TileEntityFissionFuelAssembly;
                }
            }).calculate((Coord4D)elements.iterator().next());
        }
        if (elements.size() > structure.superheatingElements) {
            return false;
        }
        Coord4D initAir = null;
        int totalAir = 0;
        for (int x = structure.renderLocation.x; x < structure.renderLocation.x + structure.volLength; ++x) {
            for (int y = structure.renderLocation.y; y < initDisperser.y; ++y) {
                for (int z = structure.renderLocation.z; z < structure.renderLocation.z + structure.volWidth; ++z) {
                    if (!this.pointer.func_145831_w().func_175623_d(new BlockPos(x, y, z)) && !this.isViableNode(x, y, z)) continue;
                    initAir = new Coord4D(x, y, z, this.pointer.func_145831_w().field_73011_w.getDimension());
                    ++totalAir;
                }
            }
        }
        if (initAir == null) {
            return false;
        }
        final Coord4D renderLocation = structure.renderLocation;
        final int volLength = structure.volLength;
        final int volWidth = structure.volWidth;
        structure.waterVolume = new UpdateProtocol.NodeCounter(new UpdateProtocol.NodeChecker(){

            @Override
            public final boolean isValid(Coord4D coord) {
                return coord.y >= renderLocation.y - 1 && coord.y < initDisperser.y && coord.x >= renderLocation.x && coord.x < renderLocation.x + volLength && coord.z >= renderLocation.z && coord.z < renderLocation.z + volWidth && (coord.isAirBlock((IBlockAccess)FissionUpdateProtocol.this.pointer.func_145831_w()) || FissionUpdateProtocol.this.isViableNode(coord.getPos()));
            }
        }).calculate(initAir);
        if (totalAir > structure.waterVolume) {
            return false;
        }
        int steamHeight = structure.renderLocation.y + structure.volHeight - 2 - initDisperser.y;
        structure.steamVolume = structure.volWidth * structure.volLength * steamHeight;
        structure.upperRenderLocation = new Coord4D(structure.renderLocation.x, initDisperser.y + 1, structure.renderLocation.z, this.pointer.func_145831_w().field_73011_w.getDimension());
        return true;
    }

    protected FissionCache getNewCache() {
        return new FissionCache();
    }

    @Override
    protected SynchronizedFissionData getNewStructure() {
        return new SynchronizedFissionData();
    }

    @Override
    protected MultiblockManager<SynchronizedFissionData> getManager() {
        return MekanismGenerators.fissionMangaer;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedFissionData> cache, MultiblockCache<SynchronizedFissionData> merge) {
        FissionCache boilerCache = (FissionCache)cache;
        FissionCache mergeCache = (FissionCache)merge;
        if (boilerCache.water == null) {
            boilerCache.water = mergeCache.water;
        } else if (mergeCache.water != null && boilerCache.water.isFluidEqual(mergeCache.water)) {
            boilerCache.water.amount += mergeCache.water.amount;
        }
        if (boilerCache.steam == null) {
            boilerCache.steam = mergeCache.steam;
        } else if (mergeCache.steam != null && boilerCache.steam.isFluidEqual(mergeCache.steam)) {
            boilerCache.steam.amount += mergeCache.steam.amount;
        }
        if (boilerCache.input == null) {
            boilerCache.input = mergeCache.input;
        } else if (mergeCache.input != null && boilerCache.input.isGasEqual(mergeCache.input)) {
            boilerCache.input.amount += mergeCache.input.amount;
        }
        if (boilerCache.output == null) {
            boilerCache.output = mergeCache.output;
        } else if (mergeCache.output != null && boilerCache.output.isGasEqual(mergeCache.output)) {
            boilerCache.output.amount += mergeCache.output.amount;
        }
        boilerCache.temperature = Math.max(boilerCache.temperature, mergeCache.temperature);
    }

    @Override
    protected void onFormed() {
        super.onFormed();
        if (((SynchronizedFissionData)this.structureFound).waterStored != null) {
            ((SynchronizedFissionData)this.structureFound).waterStored.amount = Math.min(((SynchronizedFissionData)this.structureFound).waterStored.amount, ((SynchronizedFissionData)this.structureFound).waterVolume * 16000);
        }
        if (((SynchronizedFissionData)this.structureFound).steamStored != null) {
            ((SynchronizedFissionData)this.structureFound).steamStored.amount = Math.min(((SynchronizedFissionData)this.structureFound).steamStored.amount, ((SynchronizedFissionData)this.structureFound).steamVolume * 160000);
        }
        if (((SynchronizedFissionData)this.structureFound).InputGas != null) {
            ((SynchronizedFissionData)this.structureFound).InputGas.amount = Math.min(((SynchronizedFissionData)this.structureFound).InputGas.amount, ((SynchronizedFissionData)this.structureFound).waterVolume * 16000);
        }
        if (((SynchronizedFissionData)this.structureFound).OutputGas != null) {
            ((SynchronizedFissionData)this.structureFound).OutputGas.amount = Math.min(((SynchronizedFissionData)this.structureFound).OutputGas.amount, ((SynchronizedFissionData)this.structureFound).steamVolume * 160000);
        }
    }

    @Override
    protected void onStructureCreated(SynchronizedFissionData structure, int origX, int origY, int origZ, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        for (Coord4D obj : structure.locations) {
            if (!(obj.getTileEntity((IBlockAccess)this.pointer.func_145831_w()) instanceof TileEntityFissionValve)) continue;
            SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
            data.location = obj;
            data.side = this.getSide(obj, origX + xmin, origX + xmax, origY + ymin, origY + ymax, origZ + zmin, origZ + zmax);
            structure.valves.add(data);
        }
    }
}

