/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.mj.MjAPI;
import io.netty.buffer.ByteBuf;
import mekanism.api.MekanismAPI;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.common.FuelHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.config.MekanismConfig;
import mekanism.common.fixers.MekanismDataFixers;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.StackUtils;
import mekanism.generators.common.CreativeTabMekanismGenerators;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.GeneratorsCommonProxy;
import mekanism.generators.common.GeneratorsGuiHandler;
import mekanism.generators.common.GeneratorsItems;
import mekanism.generators.common.content.fission.SynchronizedFissionData;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.fixers.GeneratorTEFixer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="mekanismgenerators", useMetadata=true, guiFactory="mekanism.generators.client.gui.GeneratorsGuiFactory")
@Mod.EventBusSubscriber
public class MekanismGenerators
implements IModule {
    public static final String MODID = "mekanismgenerators";
    @SidedProxy(clientSide="mekanism.generators.client.GeneratorsClientProxy", serverSide="mekanism.generators.common.GeneratorsCommonProxy")
    public static GeneratorsCommonProxy proxy;
    @Mod.Instance(value="mekanismgenerators")
    public static MekanismGenerators instance;
    public static Version versionNumber;
    public static final int DATA_VERSION = 1;
    public static CreativeTabMekanismGenerators tabMekanismGenerators;
    public static MultiblockManager<SynchronizedTurbineData> turbineManager;
    public static MultiblockManager<SynchronizedFissionData> fissionMangaer;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        GeneratorsBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        GeneratorsItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
        GeneratorsBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerBlockRenders();
        proxy.registerItemRenders();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        proxy.loadConfiguration();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Mekanism.modulesLoaded.add(this);
        PacketSimpleGui.handlers.add(1, proxy);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GeneratorsGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.registerTileEntities();
        proxy.registerTESRs();
        CompoundDataFixer fixer = FMLCommonHandler.instance().getDataFixer();
        ModFixs fixes = fixer.init(MODID, 1);
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new GeneratorTEFixer(MekanismDataFixers.MekFixers.TILE_ENTITIES));
        Mekanism.logger.info("Loaded MekanismGenerators module.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (FuelHandler.BCPresent() && BuildcraftFuelRegistry.fuel != null) {
            for (IFuel s : BuildcraftFuelRegistry.fuel.getFuels()) {
                if (s.getFluid() == null || GasRegistry.containsGas(s.getFluid().getFluid().getName())) continue;
                GasRegistry.register(new Gas(s.getFluid().getFluid()));
            }
            BuildcraftFuelRegistry.fuel.addFuel(MekanismFluids.Ethene.getFluid(), RFIntegration.toRFAsLong(12L * MjAPI.MJ), 40000);
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        FuelHandler.addGas(MekanismFluids.Ethene, MekanismConfig.current().general.ETHENE_BURN_TIME.val(), MekanismConfig.current().general.FROM_H2.val() + MekanismConfig.current().generators.bioGeneration.val() * 2.0 * (double)MekanismConfig.current().general.ETHENE_BURN_TIME.val());
        for (ItemStack ore : OreDictionary.getOres((String)"dustGold", (boolean)false)) {
            RecipeHandler.addMetallurgicInfuserRecipe(InfuseRegistry.get("CARBON"), 10, StackUtils.size(ore, 4), GeneratorsItems.Hohlraum.getEmptyItem());
        }
        RecipeHandler.addFusionCoolingRecipe(FluidRegistry.getFluidStack((String)"water", (int)1), FluidRegistry.getFluidStack((String)"steam", (int)1));
        RecipeHandler.addFusionCoolingRecipe(FluidRegistry.getFluidStack((String)"liquidsodium", (int)1), FluidRegistry.getFluidStack((String)"liquidsuperheatedsodium", (int)2));
    }

    @Override
    public Version getVersion() {
        return versionNumber;
    }

    @Override
    public String getName() {
        return "Generators";
    }

    @Override
    public void writeConfig(ByteBuf dataStream, MekanismConfig config) {
        config.generators.write(dataStream);
    }

    @Override
    public void readConfig(ByteBuf dataStream, MekanismConfig destConfig) {
        destConfig.generators.read(dataStream);
    }

    @Override
    public void resetClient() {
        SynchronizedTurbineData.clientRotationMap.clear();
        SynchronizedFissionData.clientHotMap.clear();
        proxy.setGasGeneratorMaxEnergy();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID) || event.getModID().equals("mekanism")) {
            proxy.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onBlacklistUpdate(MekanismAPI.BoxBlacklistEvent event) {
        MekanismAPI.addBoxBlacklist(GeneratorsBlocks.Generator, 5);
        MekanismAPI.addBoxBlacklist(GeneratorsBlocks.Generator, 6);
    }

    static {
        versionNumber = new Version(999, 999, 999);
        tabMekanismGenerators = new CreativeTabMekanismGenerators();
        turbineManager = new MultiblockManager("industrialTurbine");
        fissionMangaer = new MultiblockManager("fissionReactor");
    }
}

