/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import java.util.EnumMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismFluids;
import mekanism.generators.client.model.ModelBioGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.util.MekanismGeneratorUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBioGenerator
extends TileEntitySpecialRenderer<TileEntityBioGenerator> {
    public static final RenderBioGenerator INSTANCE = new RenderBioGenerator();
    private static Map<EnumFacing, MekanismRenderer.DisplayInteger[]> energyDisplays = new EnumMap<EnumFacing, MekanismRenderer.DisplayInteger[]>(EnumFacing.class);
    private ModelBioGenerator model = new ModelBioGenerator();
    private static final int stages = 800;

    public static void resetDisplayInts() {
        energyDisplays.clear();
    }

    public void render(TileEntityBioGenerator tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(MekanismGeneratorUtils.getResource(MekanismGeneratorUtils.ResourceType.RENDER, "BioGenerator.png"));
        MekanismRenderer.rotate(tileEntity.facing, 180.0f, 0.0f, 270.0f, 90.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.render(0.0625f);
        GlStateManager.func_179121_F();
        if (tileEntity.bioFuelSlot.fluidStored > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            MekanismRenderer.GlowInfo glowInfo = MekanismRenderer.enableGlow();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            this.func_147499_a(TextureMap.field_110575_b);
            MekanismRenderer.color(MekanismFluids.Biofuel);
            MekanismRenderer.DisplayInteger[] displayList = this.getDisplayList(tileEntity.facing);
            displayList[tileEntity.getScaledFuelLevel(799)].render();
            MekanismRenderer.resetColor();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(MekanismGeneratorUtils.getResource(MekanismGeneratorUtils.ResourceType.RENDER, "BioGenerator.png"));
        MekanismRenderer.rotate(tileEntity.facing, 180.0f, 0.0f, 270.0f, 90.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.renderGlass(0.0625f);
        GlStateManager.func_179121_F();
    }

    private MekanismRenderer.DisplayInteger[] getDisplayList(EnumFacing side) {
        if (energyDisplays.containsKey(side)) {
            return energyDisplays.get(side);
        }
        MekanismRenderer.Model3D model3D = new MekanismRenderer.Model3D();
        model3D.baseBlock = Blocks.field_150355_j;
        model3D.setTexture(MekanismFluids.Biofuel.getSprite());
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[800];
        energyDisplays.put(side, displays);
        for (int i = 0; i < 800; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (side) {
                case NORTH: {
                    model3D.minZ = 0.5;
                    model3D.maxZ = 0.875;
                    model3D.minX = 0.1875;
                    model3D.maxX = 0.8215;
                    break;
                }
                case SOUTH: {
                    model3D.minZ = 0.125;
                    model3D.maxZ = 0.5;
                    model3D.minX = 0.1875;
                    model3D.maxX = 0.8215;
                    break;
                }
                case WEST: {
                    model3D.minX = 0.5;
                    model3D.maxX = 0.875;
                    model3D.minZ = 0.1875;
                    model3D.maxZ = 0.8215;
                    break;
                }
                case EAST: {
                    model3D.minX = 0.125;
                    model3D.maxX = 0.5;
                    model3D.minZ = 0.1875;
                    model3D.maxZ = 0.8215;
                }
            }
            model3D.minY = 0.4385;
            model3D.maxY = 0.4375 + (double)((float)i / 800.0f) * 0.4375 + 0.001;
            MekanismRenderer.renderObject(model3D);
            MekanismRenderer.DisplayInteger.endList();
        }
        return displays;
    }
}

