/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui.element;

import mekanism.api.Coord4D;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiTabElementType;
import mekanism.client.gui.element.tab.TabType;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiReactorTab
extends GuiTabElementType<TileEntityReactorController, ReactorTab> {
    private ReactorTab tab;

    public GuiReactorTab(IGuiWrapper gui, TileEntityReactorController tile, ReactorTab type, ResourceLocation def) {
        super(gui, tile, type, def);
        this.tab = type;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(xAxis, yAxis, guiWidth, guiHeight);
        GuiReactorTab.mc.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON_TAB, "button_tab_icon.png"));
        this.guiObj.drawTexturedRect(guiWidth - 21, guiHeight + this.tab.getYPos() + 4, this.tab.xlocation, this.tab.ylocation, 18, 18);
    }

    public static enum ReactorTab implements TabType
    {
        HEAT(180, 0, 11, "gui.heat", 6),
        FUEL(234, 0, 12, "gui.fuel", 34),
        STAT(198, 18, 13, "gui.stats", 62);

        private final String description;
        public final int xlocation;
        public final int ylocation;
        private final int guiId;
        private final int yPos;

        private ReactorTab(int x, int yh, int id, String desc, int y) {
            this.xlocation = x;
            this.ylocation = yh;
            this.guiId = id;
            this.description = desc;
            this.yPos = y;
        }

        @Override
        public ResourceLocation getResource() {
            return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Null.png");
        }

        @Override
        public void openGui(TileEntity tile) {
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 1, this.guiId));
        }

        @Override
        public String getDesc() {
            return LangUtils.localize(this.description);
        }

        @Override
        public int getYPos() {
            return this.yPos;
        }
    }
}

