/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.Arrays;
import mekanism.api.EnumColor;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.inventory.container.ContainerWindGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiWindGenerator
extends GuiMekanismTile<TileEntityWindGenerator> {
    public GuiWindGenerator(InventoryPlayer inventory, TileEntityWindGenerator tile) {
        super(tile, new ContainerWindGenerator(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> Arrays.asList(LangUtils.localize("gui.producing") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityWindGenerator)this.tileEntity).getActive() ? MekanismConfig.current().generators.windGenerationMin.val() * (double)((TileEntityWindGenerator)this.tileEntity).getCurrentMultiplier() : 0.0) + "/t", LangUtils.localize("gui.maxOutput") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityWindGenerator)this.tileEntity).getMaxOutput()) + "/t"), (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.STATE_HOLDER, this, resource, 18, 35));
        this.addGuiElement(new GuiInnerScreen(this, resource, 48, 21, 80, 44));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityWindGenerator)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityWindGenerator)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(MekanismUtils.getEnergyDisplay(((TileEntityWindGenerator)this.tileEntity).getEnergy(), ((TileEntityWindGenerator)this.tileEntity).getMaxEnergy()), 51, 26, -12779878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.power") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityWindGenerator)this.tileEntity).getActive() ? MekanismConfig.current().generators.windGenerationMin.val() * (double)((TileEntityWindGenerator)this.tileEntity).getCurrentMultiplier() : 0.0) + "/t", 51, 35, -12779878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.out") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityWindGenerator)this.tileEntity).getMaxOutput()) + "/t", 51, 44, -12779878);
        int size = 44;
        boolean isblacklist = ((TileEntityWindGenerator)this.tileEntity).isBlacklistDimension();
        if (!((TileEntityWindGenerator)this.tileEntity).getActive()) {
            String info = "gui.skyBlocked";
            size += 9;
            if (isblacklist) {
                info = "gui.noWind";
            }
            if (((TileEntityWindGenerator)this.tileEntity).controlType == IRedstoneControl.RedstoneControl.HIGH && !((TileEntityWindGenerator)this.tileEntity).redstone && !isblacklist) {
                info = "control.high.desc";
            }
            if (((TileEntityWindGenerator)this.tileEntity).controlType == IRedstoneControl.RedstoneControl.LOW && ((TileEntityWindGenerator)this.tileEntity).redstone && !isblacklist) {
                info = "control.low.desc";
            }
            this.field_146289_q.func_78276_b((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize(info), 51, size, 52480);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SLOT, "Slot_Icon.png"));
        this.func_73729_b(this.field_147003_i + 20, this.field_147009_r + 37, ((TileEntityWindGenerator)this.tileEntity).getActive() ? 12 : 0, 88, 12, 12);
    }
}

