/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.Arrays;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTurbineStats
extends GuiMekanismTile<TileEntityTurbineCasing> {
    public GuiTurbineStats(InventoryPlayer inventory, TileEntityTurbineCasing tile) {
        super(tile, new ContainerNull(inventory.field_70458_d, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiTurbineTab((IGuiWrapper)this, (TileEntityTurbineCasing)this.tileEntity, GuiTurbineTab.TurbineTab.MAIN, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            double producing = ((TileEntityTurbineCasing)this.tileEntity).structure == null ? 0.0 : (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientFlow * (MekanismConfig.current().general.maxEnergyPerSteam.val() / 28.0) * (double)Math.min(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils * MekanismConfig.current().generators.turbineBladesPerCoil.val());
            return Arrays.asList(LangUtils.localize("gui.storing") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityTurbineCasing)this.tileEntity).getEnergy(), ((TileEntityTurbineCasing)this.tileEntity).getMaxEnergy()), LangUtils.localize("gui.producing") + ": " + MekanismUtils.getEnergyDisplay(producing) + "/t");
        }, (IGuiWrapper)this, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String stats = LangUtils.localize("gui.turbineStats");
        String limiting = (Object)((Object)EnumColor.DARK_RED) + " (" + LangUtils.localize("gui.limiting") + ")";
        this.field_146289_q.func_78276_b(stats, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(stats) / 2, 6, 0x404040);
        if (((TileEntityTurbineCasing)this.tileEntity).structure != null) {
            int lowerVolume = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).lowerVolume;
            int clientDispersers = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientDispersers;
            int vents = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).vents;
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.tankVolume") + ": " + lowerVolume, 8, 26, 0x404040);
            boolean dispersersLimiting = (double)(lowerVolume * clientDispersers) * MekanismConfig.current().generators.turbineDisperserGasFlow.val() < (double)vents * MekanismConfig.current().generators.turbineVentGasFlow.val();
            boolean ventsLimiting = (double)(lowerVolume * clientDispersers) * MekanismConfig.current().generators.turbineDisperserGasFlow.val() > (double)vents * MekanismConfig.current().generators.turbineVentGasFlow.val();
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.steamFlow"), 8, 40, 0x797979);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.dispersers") + ": " + clientDispersers + (dispersersLimiting ? limiting : ""), 14, 49, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.vents") + ": " + vents + (ventsLimiting ? limiting : ""), 14, 58, 0x404040);
            int coils = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils;
            int blades = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades;
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.production"), 8, 72, 0x797979);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.blades") + ": " + blades + (coils * 4 > blades ? limiting : ""), 14, 81, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.coils") + ": " + coils + (coils * 4 < blades ? limiting : ""), 14, 90, 0x404040);
            double energyMultiplier = MekanismConfig.current().general.maxEnergyPerSteam.val() / 28.0 * (double)Math.min(blades, coils * MekanismConfig.current().generators.turbineBladesPerCoil.val());
            double rate = (double)lowerVolume * ((double)clientDispersers * MekanismConfig.current().generators.turbineDisperserGasFlow.val());
            rate = Math.min(rate, (double)vents * MekanismConfig.current().generators.turbineVentGasFlow.val());
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxProduction") + ": " + MekanismUtils.getEnergyDisplay(rate * energyMultiplier), 8, 104, 0x404040);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxWaterOutput") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).condensers * MekanismConfig.current().generators.condenserRate.val() + " mB/t", 8, 113, 0x404040);
        }
        super.func_146979_b(mouseX, mouseY);
    }
}

