/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.gui.button.GuiReactorLogicButton;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.generators.common.util.MekanismGeneratorUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiReactorLogicAdapter
extends GuiMekanismTile<TileEntityReactorLogicAdapter> {
    private List<GuiReactorLogicButton> typeButtons = new ArrayList<GuiReactorLogicButton>();
    private int buttonID = 0;

    public GuiReactorLogicAdapter(InventoryPlayer inventory, TileEntityReactorLogicAdapter tile) {
        super(tile, new ContainerNull(inventory.field_70458_d, tile));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        for (TileEntityReactorLogicAdapter.ReactorLogic type : TileEntityReactorLogicAdapter.ReactorLogic.values()) {
            int typeShift = 22 * type.ordinal();
            GuiReactorLogicButton button = new GuiReactorLogicButton(this.buttonID++, this.field_147003_i + 24, this.field_147009_r + 32 + typeShift, type, (TileEntityReactorLogicAdapter)this.tileEntity, this.getGuiLocation());
            this.field_146292_n.add(button);
            this.typeButtons.add(button);
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        for (GuiReactorLogicButton button : this.typeButtons) {
            if (guibutton.field_146127_k != button.field_146127_k) continue;
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(1, button.getType().ordinal())));
            break;
        }
    }

    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis > 23 && xAxis < 33 && yAxis > 19 && yAxis < 29;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityReactorLogicAdapter)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityReactorLogicAdapter)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.coolingMeasurements") + ": " + (Object)((Object)EnumColor.RED) + LangUtils.transOnOff(((TileEntityReactorLogicAdapter)this.tileEntity).activeCooled), 36, 20, 0x404040, 117);
        this.renderScaledText(LangUtils.localize("gui.redstoneOutputMode") + ": " + (Object)((Object)EnumColor.RED) + ((TileEntityReactorLogicAdapter)this.tileEntity).logicType.getLocalizedName(), 23, 123, 0x404040, 130);
        String text = LangUtils.localize("gui.status") + ": " + (Object)((Object)EnumColor.RED) + LangUtils.localize("gui." + (((TileEntityReactorLogicAdapter)this.tileEntity).checkMode() ? "outputting" : "idle"));
        this.field_146289_q.func_78276_b(text, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(text) / 2, 136, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        for (GuiReactorLogicButton button : this.typeButtons) {
            TileEntityReactorLogicAdapter.ReactorLogic type = button.getType();
            int typeOffset = 22 * type.ordinal();
            this.renderItem(type.getRenderStack(), 27, 35 + typeOffset);
            this.field_146289_q.func_78276_b((Object)((Object)EnumColor.WHITE) + type.getLocalizedName(), 46, 34 + typeOffset, 0x404040);
            if (!button.func_146115_a()) continue;
            this.displayTooltips(MekanismUtils.splitTooltip(type.getDescription(), ItemStack.field_190927_a), xAxis, yAxis);
        }
        if (this.inBounds(xAxis, yAxis)) {
            this.displayTooltip(LangUtils.localize("gui.toggleCooling"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        ResourceLocation resource = this.getGuiLocation();
        this.field_146297_k.field_71446_o.func_110577_a(resource);
        int activecoolingButton = 176;
        if (((TileEntityReactorLogicAdapter)this.tileEntity).activeCooled) {
            activecoolingButton += 11;
        }
        this.func_73729_b(this.field_147003_i + 23, this.field_147009_r + 19, activecoolingButton, this.inBounds(xAxis, yAxis) ? 0 : 11, 11, 11);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismGeneratorUtils.getResource(MekanismGeneratorUtils.ResourceType.GUI, "GuiReactorLogicAdapter.png");
    }

    @Override
    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        int xAxis = x - this.field_147003_i;
        int yAxis = y - this.field_147009_r;
        if (this.inBounds(xAxis, yAxis)) {
            TileNetworkList data = TileNetworkList.withContents(0);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }
}

