/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.util.time.Timeticks;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiNumberGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.generators.client.gui.GuiReactorInfo;
import mekanism.generators.client.gui.element.GuiReactorTab;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiReactorHeat
extends GuiReactorInfo {
    protected Timeticks time = new Timeticks(20, 20, false);

    public GuiReactorHeat(InventoryPlayer inventory, final TileEntityReactorController tile) {
        super(tile, (Container)new ContainerNull(inventory.field_70458_d, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiEnergyInfo(() -> ((TileEntityReactorController)this.tileEntity).isFormed() ? Arrays.asList(LangUtils.localize("gui.storing") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityReactorController)this.tileEntity).getEnergy(), ((TileEntityReactorController)this.tileEntity).getMaxEnergy()), LangUtils.localize("gui.producing") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityReactorController)this.tileEntity).getReactor().getPassiveGeneration(false, true)) + "/t") : new ArrayList(), (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            @Override
            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture(FluidRegistry.LAVA, MekanismRenderer.FluidType.STILL);
            }

            @Override
            public double getLevel() {
                return UnitDisplayUtils.TemperatureUnit.AMBIENT.convertToK(((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getPlasmaTemp(), true);
            }

            @Override
            public double getMaxLevel() {
                return 5.0E8;
            }

            @Override
            public String getText(double level) {
                return LangUtils.localize("gui.Plasma") + " : " + MekanismUtils.getTemperatureDisplay(level, UnitDisplayUtils.TemperatureUnit.KELVIN);
            }
        }, GuiGauge.Type.STANDARD, this, resource, 7, 50));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getPlasmaTemp() > ((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getCaseTemp() ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.SMALL_RIGHT, this, resource, 27, 75));
        this.addGuiElement(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            @Override
            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture(FluidRegistry.LAVA, MekanismRenderer.FluidType.STILL);
            }

            @Override
            public double getLevel() {
                return UnitDisplayUtils.TemperatureUnit.AMBIENT.convertToK(((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getCaseTemp(), true);
            }

            @Override
            public double getMaxLevel() {
                return 5.0E8;
            }

            @Override
            public String getText(double level) {
                return LangUtils.localize("gui.Case") + " : " + MekanismUtils.getTemperatureDisplay(level, UnitDisplayUtils.TemperatureUnit.KELVIN);
            }
        }, GuiGauge.Type.STANDARD, this, resource, 61, 50));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getCaseTemp() > 0.0 ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.SMALL_RIGHT, this, resource, 81, 60));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getCaseTemp() > 0.0 && ((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getactivelyCooled() ? (double)GuiReactorHeat.this.time.getValue() / 20.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.SMALL_RIGHT, this, resource, 81, 90));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getCaseTemp() > 0.0 && ((TileEntityReactorController)GuiReactorHeat.this.tileEntity).getactivelyCooled() && tile.steamTank.getFluidAmount() > 0 && tile.steamTank.getFluidAmount() < tile.steamTank.getCapacity() ? (double)GuiReactorHeat.this.time.getValue() / 20.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.BI_RIGHT, this, resource, 132, 95));
        this.addGuiElement(new GuiFluidGauge(() -> ((TileEntityReactorController)this.tileEntity).waterTank, GuiGauge.Type.SMALL, this, resource, 115, 84));
        this.addGuiElement(new GuiFluidGauge(() -> ((TileEntityReactorController)this.tileEntity).steamTank, GuiGauge.Type.SMALL, this, resource, 151, 84));
        this.addGuiElement(new GuiEnergyGauge(() -> (IStrictEnergyStorage)((Object)this.tileEntity), GuiGauge.Type.SMALL, this, resource, 115, 46));
        this.addGuiElement(new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tileEntity, GuiReactorTab.ReactorTab.FUEL, resource));
        this.addGuiElement(new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tileEntity, GuiReactorTab.ReactorTab.STAT, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(((TileEntityReactorController)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityReactorController)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
    }
}

