/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.TileNetworkList;
import mekanism.api.util.time.Timeticks;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.gui.GuiReactorInfo;
import mekanism.generators.client.gui.element.GuiReactorTab;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiReactorFuel
extends GuiReactorInfo {
    protected Timeticks time = new Timeticks(20, 20, false);
    private GuiTextField injectionRateField;

    public GuiReactorFuel(InventoryPlayer inventory, TileEntityReactorController tile) {
        super(tile, (Container)new ContainerNull(inventory.field_70458_d, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiEnergyInfo(() -> ((TileEntityReactorController)this.tileEntity).isFormed() ? Arrays.asList(LangUtils.localize("gui.storing") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityReactorController)this.tileEntity).getEnergy(), ((TileEntityReactorController)this.tileEntity).getMaxEnergy()), LangUtils.localize("gui.producing") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityReactorController)this.tileEntity).getReactor().getPassiveGeneration(false, true)) + "/t") : new ArrayList(), (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityReactorController)this.tileEntity).deuteriumTank, GuiGauge.Type.SMALL, this, resource, 25, 64));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityReactorController)this.tileEntity).fuelTank, GuiGauge.Type.STANDARD, this, resource, 79, 50));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityReactorController)this.tileEntity).tritiumTank, GuiGauge.Type.SMALL, this, resource, 133, 64));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityReactorController)GuiReactorFuel.this.tileEntity).isBurning() ? (double)GuiReactorFuel.this.time.getValue() / 20.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.SMALL_RIGHT, this, resource, 45, 75));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityReactorController)GuiReactorFuel.this.tileEntity).isBurning() ? (double)GuiReactorFuel.this.time.getValue() / 20.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.SMALL_LEFT, this, resource, 99, 75));
        this.addGuiElement(new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tileEntity, GuiReactorTab.ReactorTab.HEAT, resource));
        this.addGuiElement(new GuiReactorTab((IGuiWrapper)this, (TileEntityReactorController)this.tileEntity, GuiReactorTab.ReactorTab.STAT, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(((TileEntityReactorController)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityReactorController)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        String str = LangUtils.localize("gui.reactor.injectionRate") + ": " + (((TileEntityReactorController)this.tileEntity).getReactor() == null ? "None" : Integer.valueOf(((TileEntityReactorController)this.tileEntity).getReactor().getInjectionRate()));
        this.field_146289_q.func_78276_b(str, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(str) / 2, 35, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.editrate") + ":", 50, 117, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.injectionRateField.func_146194_f();
        MekanismRenderer.resetColor();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.injectionRateField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.injectionRateField.func_146192_a(mouseX, mouseY, button);
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.injectionRateField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28 && this.injectionRateField.func_146206_l()) {
            this.setInjection();
        }
        if (Character.isDigit(c) || GuiReactorFuel.isTextboxKey(c, i)) {
            this.injectionRateField.func_146201_a(c, i);
        }
    }

    private void setInjection() {
        if (!this.injectionRateField.func_146179_b().isEmpty()) {
            int toUse = Math.max(0, Math.min(Integer.parseInt(this.injectionRateField.func_146179_b()), MekanismConfig.current().generators.reactorGeneratorInjectionRate.val()));
            toUse -= toUse % 2;
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(0, toUse)));
            this.injectionRateField.func_146180_a("");
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        String prevRad = this.injectionRateField != null ? this.injectionRateField.func_146179_b() : "";
        this.injectionRateField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 98, this.field_147009_r + 115, 26, 11);
        this.injectionRateField.func_146203_f(Integer.toString(MekanismConfig.current().generators.reactorGeneratorInjectionRate.val()).length());
        this.injectionRateField.func_146180_a(prevRad);
    }
}

