/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.io.IOException;
import java.util.Arrays;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRateBar;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiNumberGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiIndustrialTurbine
extends GuiMekanismTile<TileEntityTurbineCasing> {
    public GuiDisableableButton mode;

    public GuiIndustrialTurbine(InventoryPlayer inventory, TileEntityTurbineCasing tile) {
        super(tile, new ContainerFilter(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiTurbineTab((IGuiWrapper)this, (TileEntityTurbineCasing)this.tileEntity, GuiTurbineTab.TurbineTab.STAT, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 16));
        this.addGuiElement(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.steamInput") + ": " + (((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure == null ? 0 : ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).lastSteamInput) + " mB/t";
            }

            @Override
            public double getLevel() {
                if (((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure == null) {
                    return 0.0;
                }
                double rate = Math.min((double)(((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).lowerVolume * ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).clientDispersers) * MekanismConfig.current().generators.turbineDisperserGasFlow.val(), (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).vents * MekanismConfig.current().generators.turbineVentGasFlow.val());
                if (rate == 0.0) {
                    return 0.0;
                }
                return (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).lastSteamInput / rate;
            }
        }, resource, 40, 13));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            double producing = ((TileEntityTurbineCasing)this.tileEntity).structure == null ? 0.0 : (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientFlow * (MekanismConfig.current().general.maxEnergyPerSteam.val() / 28.0) * (double)Math.min(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils * MekanismConfig.current().generators.turbineBladesPerCoil.val());
            return Arrays.asList(LangUtils.localize("gui.storing") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityTurbineCasing)this.tileEntity).getEnergy(), ((TileEntityTurbineCasing)this.tileEntity).getMaxEnergy()), LangUtils.localize("gui.producing") + ": " + MekanismUtils.getEnergyDisplay(producing) + "/t");
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiInnerScreen(this, resource, 50, 18, 112, 50));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
        this.addGuiElement(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            @Override
            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getFluidTexture(((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure != null ? ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).fluidStored : null, MekanismRenderer.FluidType.STILL);
            }

            @Override
            public double getLevel() {
                if (((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure != null && ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).fluidStored != null) {
                    return ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).fluidStored.amount;
                }
                return 0.0;
            }

            @Override
            public double getMaxLevel() {
                if (((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure != null && ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).fluidStored != null) {
                    return ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).getFluidCapacity();
                }
                return 0.0;
            }

            @Override
            public String getText(double level) {
                return ((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure != null ? (((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).fluidStored != null ? LangUtils.localizeFluidStack(((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).fluidStored) + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tileEntity).structure).fluidStored.amount + "mB" : LangUtils.localize("gui.empty")) : "";
            }
        }, GuiGauge.Type.MEDIUM, this, resource, 6, 13));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(((TileEntityTurbineCasing)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityTurbineCasing)this.tileEntity).func_70005_c_()) / 2, 5, 0x404040);
        if (((TileEntityTurbineCasing)this.tileEntity).structure != null) {
            double energyMultiplier = MekanismConfig.current().general.maxEnergyPerSteam.val() / 28.0 * (double)Math.min(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils * MekanismConfig.current().generators.turbineBladesPerCoil.val());
            double rate = (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).lowerVolume * ((double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientDispersers * MekanismConfig.current().generators.turbineDisperserGasFlow.val());
            rate = Math.min(rate, (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).vents * MekanismConfig.current().generators.turbineVentGasFlow.val());
            this.renderScaledText(LangUtils.localize("gui.production") + ": " + MekanismUtils.getEnergyDisplay((double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientFlow * energyMultiplier), 53, 26, -12779878, 106);
            this.renderScaledText(LangUtils.localize("gui.flowRate") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientFlow + " mB/t", 53, 35, -12779878, 106);
            this.renderScaledText(LangUtils.localize("gui.capacity") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).getFluidCapacity() + " mB", 53, 44, -12779878, 106);
            this.renderScaledText(LangUtils.localize("gui.maxFlow") + ": " + rate + " mB/t", 53, 53, -12779878, 106);
            String name = LangUtils.localize(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).dumpMode.getLangKey());
            this.renderScaledText(name, 156 - (int)((float)this.field_146289_q.func_78256_a(name) * this.getNeededScale(name, 66)), 73, 0x404040, 66);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.mode = new GuiDisableableButton(0, this.field_147003_i + 159, this.field_147009_r + 72, 10, 10, () -> ((TileEntityTurbineCasing)this.tileEntity).structure != null ? ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).dumpMode.ordinal() : 0).with(GuiDisableableButton.ImageOverlay.GAS_MOD);
        this.field_146292_n.add(this.mode);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.mode.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(0)));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }
}

