/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.Arrays;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.generators.common.inventory.container.ContainerHeatGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiHeatGenerator
extends GuiMekanismTile<TileEntityHeatGenerator> {
    public GuiHeatGenerator(InventoryPlayer inventory, TileEntityHeatGenerator tile) {
        super(tile, new ContainerHeatGenerator(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> Arrays.asList(LangUtils.localize("gui.producing") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityHeatGenerator)this.tileEntity).producingEnergy) + "/t", LangUtils.localize("gui.maxOutput") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityHeatGenerator)this.tileEntity).getMaxOutput()) + "/t"), (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiFluidGauge(() -> ((TileEntityHeatGenerator)this.tileEntity).lavaTank, GuiGauge.Type.WIDE, this, resource, 55, 18));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 16, 34));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String transfer = UnitDisplayUtils.getDisplayShort(((TileEntityHeatGenerator)this.tileEntity).lastTransferLoss, false, unit);
            String environment = UnitDisplayUtils.getDisplayShort(((TileEntityHeatGenerator)this.tileEntity).lastEnvironmentLoss, false, unit);
            return Arrays.asList(LangUtils.localize("gui.transferred") + ": " + transfer + "/t", LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiPlayerSlot(this, this.getGuiLocation()));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityHeatGenerator)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityHeatGenerator)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }
}

