/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util.concurrent;

import io.netty.util.internal.ThrowableUtil;
import java.util.concurrent.RecursiveTask;
import mekanism.common.Mekanism;

public abstract class TimeRecordingTask<V>
extends RecursiveTask<V> {
    public volatile int usedTime = 0;

    @Override
    protected final V compute() {
        long start = System.nanoTime() / 1000L;
        V result = null;
        try {
            result = this.computeTask();
        }
        catch (Throwable e) {
            Mekanism.logger.warn("An error occurred during fork join task execution!");
            Mekanism.logger.warn(ThrowableUtil.stackTraceToString((Throwable)e));
        }
        this.usedTime = (int)(System.nanoTime() / 1000L - start);
        return result;
    }

    protected abstract V computeTask();
}

