/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util.concurrent;

import io.netty.util.internal.ThrowableUtil;
import mekanism.common.Mekanism;
import mekanism.common.util.concurrent.Action;

public class ActionExecutor
implements Runnable,
Comparable<ActionExecutor> {
    public final Action action;
    public final int priority;
    public volatile boolean isCompleted = false;
    public volatile int usedTime = 0;

    public ActionExecutor(Action action) {
        this(action, 0);
    }

    public ActionExecutor(Action action, int priority) {
        this.action = action;
        this.priority = priority;
    }

    @Override
    public void run() {
        long start = System.nanoTime() / 1000L;
        try {
            this.action.doAction();
        }
        catch (Throwable e) {
            Mekanism.logger.warn("An error occurred during asynchronous task execution!");
            Mekanism.logger.warn(ThrowableUtil.stackTraceToString((Throwable)e));
        }
        this.usedTime = (int)(System.nanoTime() / 1000L - start);
        this.isCompleted = true;
    }

    @Override
    public int compareTo(ActionExecutor o) {
        return o.priority - this.priority;
    }
}

