/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.common.base.IModuleUpgrade;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class UpgradeHelper
extends ItemDataUtils {
    public static int getUpgradeLevel(ItemStack stack, moduleUpgrade upgrade) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("mekData")) {
            return 0;
        }
        NBTTagCompound upgradeTag = stack.func_190925_c("mekData");
        return upgradeTag.func_74771_c(upgrade.getName());
    }

    public static void setUpgradeLevel(ItemStack stack, moduleUpgrade upgrade, int level) {
        NBTTagCompound upgradeTag = stack.func_190925_c("mekData");
        if (level >= 1) {
            upgradeTag.func_74774_a(upgrade.getName(), (byte)level);
        } else {
            upgradeTag.func_82580_o(upgrade.getName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getUpgradeStats(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        Item item = stack.func_77973_b();
        if (item instanceof IModuleUpgrade) {
            IModuleUpgrade ModuleUpgrade = (IModuleUpgrade)item;
            if (!Keyboard.isKeyDown((int)42)) {
                list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + "shift" + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails"));
            } else {
                list.add((Object)((Object)EnumColor.ORANGE) + LangUtils.localize("tooltip.hold_for_modules") + ": ");
                for (moduleUpgrade upgrade : ModuleUpgrade.getValidModule(stack)) {
                    if (UpgradeHelper.getUpgradeLevel(stack, upgrade) <= 0) continue;
                    list.add("- " + upgrade.getLangName() + (upgrade.canMultiply() ? ": " + (Object)((Object)EnumColor.GREY) + "x" + UpgradeHelper.getUpgradeLevel(stack, upgrade) : ""));
                }
            }
        }
        return list;
    }

    public static boolean isUpgradeInstalled(ItemStack stack, moduleUpgrade upgrade) {
        return UpgradeHelper.getUpgradeLevel(stack, upgrade) > 0;
    }
}

