/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import mekanism.api.gas.GasTank;
import net.minecraftforge.fluids.FluidTank;

public interface TankProvider {
    public int getTankCapacity();

    public int getTankAmount();

    public static class Gas
    implements TankProvider {
        private final GasTank handler;

        public Gas(GasTank handler) {
            this.handler = handler;
        }

        @Override
        public int getTankCapacity() {
            return this.handler.getMaxGas();
        }

        @Override
        public int getTankAmount() {
            return this.handler.getStored();
        }
    }

    public static class Fluid
    implements TankProvider {
        private final FluidTank handler;

        public Fluid(FluidTank handler) {
            this.handler = handler;
        }

        @Override
        public int getTankCapacity() {
            return this.handler.getCapacity();
        }

        @Override
        public int getTankAmount() {
            return this.handler.getFluidAmount();
        }
    }
}

