/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.EnumMap;
import java.util.Map;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.Upgrade;
import mekanism.common.base.IFactory;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.security.ISecurityItem;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class RecipeUtils {
    public static boolean areItemsEqualForCrafting(ItemStack target, ItemStack input) {
        if (target.func_190926_b() && !input.func_190926_b() || !target.func_190926_b() && input.func_190926_b()) {
            return false;
        }
        if (target.func_190926_b()) {
            return true;
        }
        if (target.func_77973_b() != input.func_77973_b()) {
            return false;
        }
        if (target.func_77952_i() != input.func_77952_i() && target.func_77952_i() != Short.MAX_VALUE) {
            return false;
        }
        Item item = target.func_77973_b();
        if (item instanceof ITierItem) {
            ITierItem targetItem = (ITierItem)item;
            item = input.func_77973_b();
            if (item instanceof ITierItem) {
                ITierItem inputItem = (ITierItem)item;
                if (targetItem.getBaseTier(target) != inputItem.getBaseTier(input)) {
                    return false;
                }
            }
        }
        if ((item = target.func_77973_b()) instanceof IFactory) {
            IFactory targetFactory = (IFactory)item;
            item = input.func_77973_b();
            if (item instanceof IFactory) {
                IFactory inputFactory = (IFactory)item;
                if (RecipeUtils.isFactory(target) && RecipeUtils.isFactory(input)) {
                    IFactory.RecipeType recipeTypeInput = inputFactory.getRecipeTypeOrNull(input);
                    return recipeTypeInput != null && targetFactory.getRecipeTypeOrNull(target) == recipeTypeInput;
                }
            }
        }
        return true;
    }

    private static boolean isFactory(ItemStack stack) {
        return BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.BASIC_FACTORY || BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.ADVANCED_FACTORY || BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.ELITE_FACTORY || BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.ULTIMATE_FACTORY || BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.CREATIVE_FACTORY;
    }

    public static ItemStack getCraftingResult(InventoryCrafting inv, ItemStack toReturn) {
        Object item;
        int i;
        Object gasFound;
        Item energyFound2;
        IEnergizedItem item2;
        Object toReturnItem;
        int invLength = inv.func_70302_i_();
        Item item3 = toReturn.func_77973_b();
        if (item3 instanceof IEnergizedItem) {
            toReturnItem = (IEnergizedItem)item3;
            double energyFound2 = 0.0;
            for (int i2 = 0; i2 < invLength; ++i2) {
                Item item4;
                ItemStack itemstack = inv.func_70301_a(i2);
                if (itemstack.func_190926_b() || !((item4 = itemstack.func_77973_b()) instanceof IEnergizedItem)) continue;
                item2 = (IEnergizedItem)item4;
                energyFound2 += item2.getEnergy(itemstack);
            }
            double energyToSet = Math.min(toReturnItem.getMaxEnergy(toReturn), energyFound2);
            if (energyToSet > 0.0) {
                toReturnItem.setEnergy(toReturn, energyToSet);
            }
        }
        if ((energyFound2 = toReturn.func_77973_b()) instanceof IGasItem) {
            toReturnItem = (IGasItem)energyFound2;
            gasFound = null;
            for (i = 0; i < invLength; ++i) {
                GasStack stored;
                ItemStack itemstack = inv.func_70301_a(i);
                if (itemstack.func_190926_b() || !((item2 = itemstack.func_77973_b()) instanceof IGasItem) || (stored = (item = (IGasItem)((Object)item2)).getGas(itemstack)) == null) continue;
                if (!toReturnItem.canReceiveGas(toReturn, stored.getGas())) {
                    return ItemStack.field_190927_a;
                }
                if (gasFound == null) {
                    gasFound = stored;
                    continue;
                }
                if (gasFound.getGas() != stored.getGas()) {
                    return ItemStack.field_190927_a;
                }
                gasFound.amount += stored.amount;
            }
            if (gasFound != null) {
                gasFound.amount = Math.min(toReturnItem.getMaxGas(toReturn), gasFound.amount);
                toReturnItem.setGas(toReturn, (GasStack)gasFound);
            }
        }
        if ((gasFound = toReturn.func_77973_b()) instanceof ISecurityItem) {
            toReturnItem = (ISecurityItem)gasFound;
            for (int i3 = 0; i3 < invLength; ++i3) {
                ItemStack itemstack = inv.func_70301_a(i3);
                if (itemstack.func_190926_b() || !((item = itemstack.func_77973_b()) instanceof ISecurityItem)) continue;
                ISecurityItem item5 = (ISecurityItem)item;
                toReturnItem.setOwnerUUID(toReturn, item5.getOwnerUUID(itemstack));
                toReturnItem.setSecurity(toReturn, item5.getSecurity(itemstack));
                break;
            }
        }
        if (FluidContainerUtils.isFluidContainer(toReturn)) {
            FluidStack fluidFound = null;
            for (int i4 = 0; i4 < invLength; ++i4) {
                FluidStack stored;
                ItemStack itemstack = inv.func_70301_a(i4);
                if (!FluidContainerUtils.isFluidContainer(itemstack) || (stored = FluidUtil.getFluidContained((ItemStack)itemstack)) == null) continue;
                if (FluidUtil.getFluidHandler((ItemStack)itemstack).fill(stored, false) == 0) {
                    return ItemStack.field_190927_a;
                }
                if (fluidFound == null) {
                    fluidFound = stored;
                    continue;
                }
                if (fluidFound.getFluid() != stored.getFluid()) {
                    return ItemStack.field_190927_a;
                }
                fluidFound.amount += stored.amount;
            }
            if (fluidFound != null) {
                FluidUtil.getFluidHandler((ItemStack)toReturn).fill(fluidFound, true);
            }
        }
        if (BlockStateBasic.BasicBlockType.get(toReturn) == BlockStateBasic.BasicBlockType.BIN) {
            int foundCount = 0;
            ItemStack foundType = ItemStack.field_190927_a;
            for (i = 0; i < invLength; ++i) {
                ItemStack itemstack = inv.func_70301_a(i);
                if (itemstack.func_190926_b() || BlockStateBasic.BasicBlockType.get(itemstack) != BlockStateBasic.BasicBlockType.BIN) continue;
                InventoryBin binInv = new InventoryBin(itemstack);
                foundCount = binInv.getItemCount();
                foundType = binInv.getItemType();
            }
            if (foundCount > 0 && !foundType.func_190926_b()) {
                InventoryBin binInv = new InventoryBin(toReturn);
                binInv.setItemCount(foundCount);
                binInv.setItemType(foundType);
            }
        }
        if (BlockStateMachine.MachineType.get(toReturn) != null && BlockStateMachine.MachineType.get((ItemStack)toReturn).supportsUpgrades) {
            EnumMap<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
            for (int i5 = 0; i5 < invLength; ++i5) {
                ItemStack itemstack = inv.func_70301_a(i5);
                if (itemstack.func_190926_b() || BlockStateMachine.MachineType.get(itemstack) == null || !BlockStateMachine.MachineType.get((ItemStack)itemstack).supportsUpgrades) continue;
                Map<Upgrade, Integer> stackMap = Upgrade.buildMap(ItemDataUtils.getDataMapIfPresent(itemstack));
                for (Map.Entry<Upgrade, Integer> entry : stackMap.entrySet()) {
                    if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                    upgrades.compute(entry.getKey(), (k, val) -> Math.min(((Upgrade)((Object)((Object)entry.getKey()))).getMax(), (val != null ? val : 0) + (Integer)entry.getValue()));
                }
            }
            if (ItemDataUtils.hasData(toReturn, "upgrades")) {
                Upgrade.saveMap(upgrades, ItemDataUtils.getDataMap(toReturn));
            }
        }
        return toReturn;
    }

    public static IRecipe getRecipeFromGrid(InventoryCrafting inv, World world) {
        return CraftingManager.func_192413_b((InventoryCrafting)inv, (World)world);
    }
}

