/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonNullListSynchronized<E>
extends NonNullList<E> {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    @NotNull
    public static <E> NonNullListSynchronized<E> create() {
        return new NonNullListSynchronized<E>();
    }

    @NotNull
    public static <E> NonNullListSynchronized<E> withSize(int size, @NotNull E fill) {
        Validate.notNull(fill);
        Object[] filled = new Object[size];
        Arrays.fill(filled, fill);
        return new NonNullListSynchronized<E>(new ObjectArrayList(filled), fill);
    }

    protected NonNullListSynchronized() {
        this((List<Object>)new ObjectArrayList(), null);
    }

    protected NonNullListSynchronized(List<E> delegateIn, @Nullable E listType) {
        super(delegateIn, listType);
    }

    public int size() {
        try {
            this.rwLock.readLock().lock();
            int n = super.size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void clear() {
        try {
            this.rwLock.writeLock().lock();
            super.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @NotNull
    public E get(int idx) {
        try {
            this.rwLock.readLock().lock();
            Object object = super.get(idx);
            return (E)object;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public E set(int idx, @NotNull E element) {
        try {
            this.rwLock.writeLock().lock();
            Object object = super.set(idx, element);
            return (E)object;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void add(int idx, @NotNull E element) {
        try {
            this.rwLock.writeLock().lock();
            super.add(idx, element);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public boolean add(E e) {
        try {
            this.rwLock.writeLock().lock();
            boolean bl = super.add(e);
            return bl;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public E remove(int idx) {
        try {
            this.rwLock.writeLock().lock();
            Object object = super.remove(idx);
            return (E)object;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

