/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public final class MultipartUtils {
    public static AxisAlignedBB rotate(AxisAlignedBB aabb, EnumFacing side) {
        Vec3d v1 = MultipartUtils.rotate(new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), side);
        Vec3d v2 = MultipartUtils.rotate(new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f), side);
        return new AxisAlignedBB(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c);
    }

    public static Vec3d rotate(Vec3d vec, EnumFacing side) {
        Vec3d vec3d;
        switch (side) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DOWN: {
                vec3d = new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                break;
            }
            case UP: {
                vec3d = new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
                break;
            }
            case NORTH: {
                vec3d = new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
                break;
            }
            case SOUTH: {
                vec3d = new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
                break;
            }
            case WEST: {
                vec3d = new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
                break;
            }
            case EAST: {
                vec3d = new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
        }
        return vec3d;
    }

    public static Pair<Vec3d, Vec3d> getRayTraceVectors(EntityPlayer player) {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        float f1 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = f2 * f3;
        float f6 = f1 * f3;
        double d3 = 5.0;
        if (player instanceof EntityPlayerMP) {
            d3 = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        }
        Vec3d end = start.func_72441_c((double)f5 * d3, (double)f4 * d3, (double)f6 * d3);
        return Pair.of((Object)start, (Object)end);
    }

    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, Collection<AxisAlignedBB> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult hit = null;
        int i = -1;
        for (AxisAlignedBB aabb : boxes) {
            double d;
            AdvancedRayTraceResult result;
            AdvancedRayTraceResult advancedRayTraceResult = result = aabb == null ? null : MultipartUtils.collisionRayTrace(pos, start, end, aabb, i, null);
            if (result != null && (d = result.squareDistanceTo(start)) < minDistance) {
                minDistance = d;
                hit = result;
            }
            ++i;
        }
        return hit;
    }

    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB bounds, int subHit, Object hitInfo) {
        RayTraceResult result = bounds.func_186670_a(pos).func_72327_a(start, end);
        if (result == null) {
            return null;
        }
        result = new RayTraceResult(RayTraceResult.Type.BLOCK, result.field_72307_f, result.field_178784_b, pos);
        result.subHit = subHit;
        result.hitInfo = hitInfo;
        return new AdvancedRayTraceResult(result, bounds);
    }

    public static class AdvancedRayTraceResult
    extends AdvancedRayTraceResultBase<RayTraceResult> {
        public AdvancedRayTraceResult(RayTraceResult mop, AxisAlignedBB bounds) {
            super(mop, bounds);
        }
    }

    private static class AdvancedRayTraceResultBase<T extends RayTraceResult> {
        public final AxisAlignedBB bounds;
        public final T hit;

        public AdvancedRayTraceResultBase(T mop, AxisAlignedBB aabb) {
            this.hit = mop;
            this.bounds = aabb;
        }

        public boolean valid() {
            return this.hit != null && this.bounds != null;
        }

        public double squareDistanceTo(Vec3d vec) {
            return ((RayTraceResult)this.hit).field_72307_f.func_72436_e(vec);
        }
    }
}

