/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class MultiFluidTank
implements IFluidHandler {
    private final FluidStack[] contents;
    private final IFluidTankProperties[] props;
    private int capacity;

    public MultiFluidTank(int capacity, int tankCount) {
        this.capacity = capacity;
        this.contents = new FluidStack[tankCount];
        this.props = new IFluidTankProperties[tankCount];
        for (int i = 0; i < this.props.length; ++i) {
            this.props[i] = new FluidTankProperties(i);
        }
    }

    public MultiFluidTank(MultiFluidTank from) {
        this(from.capacity, from.contents.length);
        for (int i = 0; i < this.contents.length; ++i) {
            FluidStack stack = from.contents[i];
            if (stack == null) continue;
            this.contents[i] = stack.copy();
        }
    }

    public MultiFluidTank(IFluidHandler from) {
        this(0, from.getTankProperties().length);
        IFluidTankProperties[] properties = from.getTankProperties();
        for (int i = 0; i < this.contents.length; ++i) {
            IFluidTankProperties prop = properties[i];
            this.capacity = Math.max(this.capacity, prop.getCapacity());
            FluidStack stack = prop.getContents();
            if (stack == null) continue;
            this.contents[i] = stack.copy();
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public MultiFluidTank setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.props;
    }

    public synchronized int fill(FluidStack fluid, boolean doFill) {
        if (fluid == null || fluid.amount <= 0) {
            return 0;
        }
        FluidStack insert = fluid.copy();
        int totalFillAmount = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            int filled = this.fill(i, insert, doFill);
            totalFillAmount += filled;
            if (insert.amount <= filled) break;
            insert.amount -= filled;
        }
        return totalFillAmount;
    }

    public int fill(int slot, FluidStack insert, boolean doFill) {
        if (insert == null || insert.amount <= 0) {
            return 0;
        }
        FluidStack content = this.contents[slot];
        if (content == null) {
            if (this.capacity > insert.amount) {
                if (doFill) {
                    this.contents[slot] = insert;
                }
                return insert.amount;
            }
            if (doFill) {
                FluidStack copied = insert.copy();
                copied.amount = this.capacity;
                this.contents[slot] = copied;
            }
            return this.capacity;
        }
        if (!content.isFluidEqual(insert) || content.amount >= this.capacity) {
            return 0;
        }
        int maxCanFill = this.capacity - content.amount;
        if (maxCanFill > insert.amount) {
            if (doFill) {
                content.amount += insert.amount;
            }
            return insert.amount;
        }
        if (doFill) {
            content.amount = this.capacity;
        }
        return maxCanFill;
    }

    @Nullable
    public synchronized FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount <= 0) {
            return null;
        }
        FluidStack res = resource.copy();
        int totalDrainAmount = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            FluidStack drainedStack;
            FluidStack content = this.contents[i];
            if (content == null || !content.isFluidEqual(res) || (drainedStack = this.drain(i, res.amount, doDrain)) == null) continue;
            int drained = drainedStack.amount;
            totalDrainAmount += drained;
            if (drained >= res.amount) break;
            res.amount -= drained;
        }
        FluidStack drained = res.copy();
        drained.amount = totalDrainAmount;
        return drained;
    }

    @Nullable
    public FluidStack drain(int slot, int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        FluidStack content = this.contents[slot];
        if (content == null) {
            return null;
        }
        if (content.amount < maxDrain) {
            if (doDrain) {
                this.contents[slot] = null;
                return content;
            }
            return content.copy();
        }
        if (doDrain) {
            content.amount -= maxDrain;
        }
        FluidStack copied = content.copy();
        copied.amount = maxDrain;
        return copied;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        FluidStack toDrain = Arrays.stream(this.contents).filter(Objects::nonNull).findFirst().map(FluidStack::copy).orElse(null);
        if (toDrain == null) {
            return null;
        }
        toDrain.amount = maxDrain;
        return this.drain(toDrain, doDrain);
    }

    public void readFromNBT(NBTTagCompound compound, String name) {
        NBTTagCompound tag = compound.func_74775_l(name);
        Arrays.fill(this.contents, null);
        if (tag.func_82582_d()) {
            return;
        }
        for (int i = 0; i < this.contents.length; ++i) {
            NBTTagCompound t = tag.func_74775_l("#" + i);
            this.contents[i] = t.func_82582_d() ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)t);
        }
    }

    public void writeToNBT(NBTTagCompound compound, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < this.contents.length; ++i) {
            FluidStack stack = this.contents[i];
            if (stack == null) continue;
            NBTTagCompound t = new NBTTagCompound();
            stack.writeToNBT(t);
            tag.func_74782_a("#" + i, (NBTBase)t);
        }
        compound.func_74782_a(name, (NBTBase)tag);
    }

    public class FluidTankProperties
    implements IFluidTankProperties {
        private final int index;

        public FluidTankProperties(int index) {
            this.index = index;
        }

        @Nullable
        public FluidStack getContents() {
            return MultiFluidTank.this.contents[this.index];
        }

        public int getCapacity() {
            return MultiFluidTank.this.capacity;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return true;
        }
    }
}

