/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import mekanism.api.IHeatTransfer;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class HeatUtils {
    public static double[] simulate(IHeatTransfer source) {
        double[] heatTransferred = new double[]{0.0, 0.0};
        for (EnumFacing side : EnumFacing.field_82609_l) {
            double heatToTransfer;
            double invConduction;
            IHeatTransfer sink = source.getAdjacent(side);
            if (sink != null) {
                ICapabilityProvider provider;
                invConduction = sink.getInverseConductionCoefficient() + source.getInverseConductionCoefficient();
                heatToTransfer = source.getTemp() / invConduction;
                source.transferHeatTo(-heatToTransfer);
                sink.transferHeatTo(heatToTransfer);
                if (sink instanceof ICapabilityProvider && CapabilityUtils.hasCapability(provider = (ICapabilityProvider)sink, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d())) continue;
                heatTransferred[0] = heatTransferred[0] + heatToTransfer;
                continue;
            }
            invConduction = 10000.0 + source.getInsulationCoefficient(side) + source.getInverseConductionCoefficient();
            heatToTransfer = source.getTemp() / invConduction;
            source.transferHeatTo(-heatToTransfer);
            heatTransferred[1] = heatTransferred[1] + heatToTransfer;
        }
        return heatTransferred;
    }
}

