/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.base.target.GasHandlerTarget;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class GasUtils {
    public static IGasHandler[] getConnectedAcceptors(BlockPos pos, World world, Collection<EnumFacing> sides) {
        IGasHandler[] acceptors = new IGasHandler[]{null, null, null, null, null, null};
        EmitUtils.forEachSide(world, pos, sides, (tile, side) -> {
            acceptors[side.ordinal()] = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, side.func_176734_d());
        });
        return acceptors;
    }

    public static IGasHandler[] getConnectedAcceptors(BlockPos pos, World world) {
        return GasUtils.getConnectedAcceptors(pos, world, EnumSet.allOf(EnumFacing.class));
    }

    public static boolean isValidAcceptorOnSide(TileEntity tile, EnumFacing side) {
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d())) {
            return false;
        }
        return CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, side.func_176734_d());
    }

    public static void clearIfInvalid(GasTank tank, Predicate<Gas> isValid) {
        Gas gas;
        if (MekanismConfig.current().general.voidInvalidGases.val() && (gas = tank.getGasType()) != null && !isValid.test(gas)) {
            tank.setGas(null);
        }
    }

    public static GasStack removeGas(ItemStack itemStack, Gas type, int amount) {
        Item item;
        if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) instanceof IGasItem) {
            IGasItem item2 = (IGasItem)item;
            if (type != null && item2.getGas(itemStack) != null && item2.getGas(itemStack).getGas() != type || !item2.canProvideGas(itemStack, type)) {
                return null;
            }
            return item2.removeGas(itemStack, amount);
        }
        return null;
    }

    public static int addGas(ItemStack itemStack, GasStack stack) {
        IGasItem gasItem;
        Item item;
        if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) instanceof IGasItem && (gasItem = (IGasItem)item).canReceiveGas(itemStack, stack.getGas())) {
            return gasItem.addGas(itemStack, stack.copy());
        }
        return 0;
    }

    public static int emit(GasStack stack, TileEntity from, Set<EnumFacing> sides) {
        int curHandlers;
        if (stack == null || stack.amount == 0) {
            return 0;
        }
        GasHandlerTarget target = new GasHandlerTarget(stack);
        if (from != null) {
            EmitUtils.forEachSide(from.func_145831_w(), from.func_174877_v(), sides, (acceptor, side) -> {
                EnumFacing accessSide = side.func_176734_d();
                CapabilityUtils.runIfCap((ICapabilityProvider)acceptor, Capabilities.GAS_HANDLER_CAPABILITY, accessSide, handler -> {
                    if (handler.canReceiveGas(accessSide, stack.getGas())) {
                        target.addHandler(accessSide, handler);
                    }
                });
            });
        }
        if ((curHandlers = target.getHandlers().size()) > 0) {
            return EmitUtils.sendToAcceptors(Collections.singleton(target), curHandlers, stack.amount, stack);
        }
        return 0;
    }

    public static void writeSustainedData(GasTank gasTank, ItemStack itemStack) {
        if (gasTank.stored != null && gasTank.stored.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "gasStored", gasTank.stored.write(new NBTTagCompound()));
        }
    }

    public static void readSustainedData(GasTank gasTank, ItemStack itemStack) {
        gasTank.stored = ItemDataUtils.hasData(itemStack, "gasStored") ? GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "gasStored")) : null;
    }

    public static boolean canDrain(@Nullable GasStack tankGas, @Nullable Gas outGas) {
        return tankGas != null && (outGas == null || tankGas.isGasEqual(outGas));
    }
}

