/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.Nullable;

public class FluidTankSync
extends FluidTank {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public FluidTankSync(int capacity) {
        super(capacity);
    }

    public FluidTankSync(@Nullable FluidStack fluidStack, int capacity) {
        super(fluidStack, capacity);
    }

    public FluidTankSync(Fluid fluid, int amount, int capacity) {
        super(fluid, amount, capacity);
    }

    public void setFluid(@Nullable FluidStack fluid) {
        try {
            this.rwLock.writeLock().lock();
            super.setFluid(fluid);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void setTileEntity(TileEntity tile) {
        try {
            this.rwLock.writeLock().lock();
            super.setTileEntity(tile);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void setCapacity(int capacity) {
        try {
            this.rwLock.writeLock().lock();
            super.setCapacity(capacity);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(FluidStack resource, boolean doFill) {
        try {
            this.rwLock.writeLock().lock();
            int n = super.fill(resource, doFill);
            return n;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fillInternal(FluidStack resource, boolean doFill) {
        try {
            this.rwLock.writeLock().lock();
            int n = super.fillInternal(resource, doFill);
            return n;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        try {
            this.rwLock.writeLock().lock();
            FluidStack fluidStack = super.drain(resource, doDrain);
            return fluidStack;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluidStack drain(int maxDrain, boolean doDrain) {
        try {
            this.rwLock.writeLock().lock();
            FluidStack fluidStack = super.drain(maxDrain, doDrain);
            return fluidStack;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        try {
            this.rwLock.writeLock().lock();
            FluidStack fluidStack = super.drainInternal(resource, doDrain);
            return fluidStack;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        try {
            this.rwLock.writeLock().lock();
            FluidStack fluidStack = super.drainInternal(maxDrain, doDrain);
            return fluidStack;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Nullable
    public FluidStack getFluid() {
        try {
            this.rwLock.readLock().lock();
            FluidStack fluidStack = super.getFluid();
            return fluidStack;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public int getFluidAmount() {
        try {
            this.rwLock.readLock().lock();
            int n = super.getFluidAmount();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public int getCapacity() {
        try {
            this.rwLock.readLock().lock();
            int n = super.getCapacity();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public FluidTankInfo getInfo() {
        try {
            this.rwLock.readLock().lock();
            FluidTankInfo fluidTankInfo = super.getInfo();
            return fluidTankInfo;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        try {
            this.rwLock.readLock().lock();
            IFluidTankProperties[] iFluidTankPropertiesArray = super.getTankProperties();
            return iFluidTankPropertiesArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public ReadWriteLock getRwLock() {
        return this.rwLock;
    }
}

