/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.TankProvider;
import net.minecraft.util.math.MathHelper;

public class EjectSpeedController {
    private final List<TankProvider> tanks = new ObjectArrayList(2);
    private final List<TankRecord> tankRecords = new ObjectArrayList(2);

    public void record(int tankIdx) {
        TankProvider provider = this.tanks.get(tankIdx);
        TankRecord record = this.tankRecords.get(tankIdx);
        record.record(provider);
    }

    public void eject(int tankIdx, int amount) {
        TankRecord record = this.tankRecords.get(tankIdx);
        record.eject(amount);
    }

    public int getEjectSpeed(int tankIdx) {
        return this.tankRecords.get(tankIdx).getEjectSpeed(this.tanks.get(tankIdx));
    }

    public boolean canEject(int tankIdx) {
        return this.tankRecords.get(tankIdx).canEject(this.tanks.get(tankIdx));
    }

    public void reset() {
        this.tanks.clear();
        this.tankRecords.clear();
    }

    public void ensureSize(int size, Supplier<List<TankProvider>> tanksProvider) {
        if (size != this.tanks.size()) {
            this.tanks.clear();
            this.tanks.addAll((Collection<TankProvider>)tanksProvider.get());
            this.tankRecords.clear();
            for (int i = 0; i < this.tanks.size(); ++i) {
                this.tankRecords.add(new TankRecord());
            }
        }
    }

    public static final class TankRecord {
        public static final int MAX_WORK_DELAY = MekanismConfig.current().mekce.MaximumEjectionDelay.val();
        public static final int MAX_TANK_RECORDS = MekanismConfig.current().mekce.TankChangeSpeed.val();
        public static final float LOW_THRESHOLD = MekanismConfig.current().mekce.LowEjectionThreshold.val();
        public static final float HIGH_THRESHOLD = MekanismConfig.current().mekce.HighEjectionThreshold.val();
        private final IntArrayFIFOQueue tankRecords = new IntArrayFIFOQueue();
        private int lastTankAmount = 0;
        private int tankChangeSpeedTotal = 0;
        private int tankChangeSpeedAvg = 0;
        private int lastEjectAmount = 0;
        private int ejectSpeedMax = 0;
        private int ejectDelay = -1;

        private TankRecord() {
        }

        public void record(TankProvider tank) {
            if (this.tankRecords.size() >= MAX_TANK_RECORDS) {
                int last = this.tankRecords.dequeueInt();
                this.tankChangeSpeedTotal -= last;
            }
            int tankAmount = tank.getTankAmount();
            int changed = tankAmount + this.lastEjectAmount - this.lastTankAmount;
            this.tankRecords.enqueue(changed);
            this.tankChangeSpeedTotal += changed;
            this.tankChangeSpeedAvg = this.tankChangeSpeedTotal / this.tankRecords.size();
            this.lastTankAmount = tankAmount;
            this.lastEjectAmount = 0;
            if ((float)tank.getTankAmount() / (float)tank.getTankCapacity() >= HIGH_THRESHOLD) {
                this.ejectDelay = 0;
                this.ejectSpeedMax = 0;
            }
        }

        public void eject(int amount) {
            this.ejectSpeedMax = Math.max(this.ejectSpeedMax, amount);
            this.lastEjectAmount = amount;
        }

        public int getEjectSpeed(TankProvider tank) {
            if (this.tankChangeSpeedAvg <= 0) {
                return MAX_WORK_DELAY;
            }
            return (int)MathHelper.func_76131_a((float)((float)Math.min(this.ejectSpeedMax, tank.getTankCapacity() - tank.getTankAmount()) / (float)this.tankChangeSpeedAvg), (float)1.0f, (float)MAX_WORK_DELAY);
        }

        public boolean canEject(TankProvider tank) {
            if (this.ejectDelay == -1) {
                this.ejectDelay = this.getEjectSpeed(tank);
                return false;
            }
            --this.ejectDelay;
            if (this.ejectDelay <= 0) {
                if ((float)tank.getTankAmount() / (float)tank.getTankCapacity() <= LOW_THRESHOLD) {
                    this.ejectSpeedMax = (int)((double)this.ejectSpeedMax * 1.2);
                }
                this.ejectDelay = this.getEjectSpeed(tank);
                return true;
            }
            return false;
        }
    }
}

