/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.energy.EnergyStack;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.base.EnergyAcceptorWrapper;
import mekanism.common.base.target.EnergyAcceptorTarget;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EnergyNetwork
extends DynamicNetwork<EnergyAcceptorWrapper, EnergyNetwork, EnergyStack> {
    public double clientEnergyScale = 0.0;
    public EnergyStack buffer = new EnergyStack(0.0);
    private double lastPowerScale = 0.0;
    private double joulesTransmitted = 0.0;
    private double jouleBufferLastTick = 0.0;
    private final ReferenceSet<EnergyAcceptorTarget> targets = new ReferenceOpenHashSet();
    private volatile int totalHandlers = 0;

    public EnergyNetwork() {
    }

    public EnergyNetwork(Collection<EnergyNetwork> networks) {
        for (EnergyNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.register();
    }

    @Override
    public void adoptTransmittersAndAcceptorsFrom(EnergyNetwork net) {
        if (net.jouleBufferLastTick > this.jouleBufferLastTick || net.clientEnergyScale > this.clientEnergyScale) {
            this.clientEnergyScale = net.clientEnergyScale;
            this.jouleBufferLastTick = net.jouleBufferLastTick;
            this.joulesTransmitted = net.joulesTransmitted;
            this.lastPowerScale = net.lastPowerScale;
        }
        this.buffer.amount += net.buffer.amount;
        super.adoptTransmittersAndAcceptorsFrom(net);
    }

    public static double round(double d) {
        return Math.round(d * 10000.0) / 10000L;
    }

    @Override
    @Nullable
    public EnergyStack getBuffer() {
        return this.buffer;
    }

    @Override
    public void absorbBuffer(IGridTransmitter<EnergyAcceptorWrapper, EnergyNetwork, EnergyStack> transmitter) {
        EnergyStack energy = transmitter.getBuffer();
        this.buffer.amount += energy.amount;
        energy.amount = 0.0;
    }

    @Override
    public void clampBuffer() {
        if (this.buffer.amount > this.getCapacityAsDouble()) {
            this.buffer.amount = this.getCapacityAsDouble();
        }
        if (this.buffer.amount < 0.0) {
            this.buffer.amount = 0.0;
        }
    }

    public double getEnergyNeeded() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        return this.getCapacityAsDouble() - this.buffer.amount;
    }

    public double emit(double energyToSend, boolean doEmit) {
        double toUse = Math.min(this.getEnergyNeeded(), energyToSend);
        if (doEmit) {
            this.buffer.amount += toUse;
        }
        return energyToSend - toUse;
    }

    public String toString() {
        return "[EnergyNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public void preTick() {
        super.onUpdate();
        this.clearJoulesTransmitted();
        if (!FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return;
        }
        double currentPowerScale = this.getPowerScale();
        if (Math.abs(currentPowerScale - this.lastPowerScale) > 0.01 || currentPowerScale != this.lastPowerScale && (currentPowerScale == 0.0 || currentPowerScale == 1.0)) {
            this.needsUpdate = true;
        }
        if (this.needsUpdate) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTransferEvent(this, currentPowerScale));
            this.lastPowerScale = currentPowerScale;
            this.needsUpdate = false;
        }
    }

    @Override
    public void onParallelTick() {
        if (this.buffer.amount > 0.0) {
            this.collectTargets();
        }
    }

    @Override
    public void onUpdate() {
        if (!FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return;
        }
        if (this.buffer.amount > 0.0) {
            this.joulesTransmitted = this.tickEmit(this.buffer.amount);
            this.buffer.amount -= this.joulesTransmitted;
        }
    }

    private double tickEmit(double energyToSend) {
        return EmitUtils.sendToAcceptors(this.targets, this.totalHandlers, energyToSend);
    }

    private void collectTargets() {
        ReferenceSet<EnergyAcceptorTarget> targets = this.targets;
        targets.clear();
        int totalHandlers = 0;
        for (Coord4D coord : this.possibleAcceptors) {
            TileEntity tile;
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            if (sides == null || sides.isEmpty() || (tile = coord.getTileEntity((IBlockAccess)this.getWorld())) == null) continue;
            EnergyAcceptorTarget target = new EnergyAcceptorTarget();
            for (EnumFacing side : sides) {
                EnergyAcceptorWrapper acceptor = EnergyAcceptorWrapper.get(tile, side);
                if (acceptor == null || !acceptor.canReceiveEnergy(side) || !acceptor.needsEnergy(side)) continue;
                target.addHandler(side, acceptor);
            }
            int curHandlers = target.getHandlers().size();
            if (curHandlers <= 0) continue;
            targets.add((Object)target);
            totalHandlers += curHandlers;
        }
        this.totalHandlers = totalHandlers;
    }

    public double getPowerScale() {
        return Math.max(this.jouleBufferLastTick == 0.0 ? 0.0 : Math.min(Math.ceil(Math.log10(this.getPower()) * 2.0) / 10.0, 1.0), this.getCapacityAsDouble() == 0.0 ? 0.0 : this.buffer.amount / this.getCapacityAsDouble());
    }

    public void clearJoulesTransmitted() {
        this.jouleBufferLastTick = this.buffer.amount;
        this.joulesTransmitted = 0.0;
    }

    public double getPower() {
        return this.jouleBufferLastTick * 20.0;
    }

    @Override
    public String getNeededInfo() {
        return MekanismUtils.getEnergyDisplay(this.getEnergyNeeded());
    }

    @Override
    public String getStoredInfo() {
        return MekanismUtils.getEnergyDisplay(this.buffer.amount);
    }

    @Override
    public String getFlowInfo() {
        return MekanismUtils.getEnergyDisplay(this.joulesTransmitted) + "/t";
    }

    public static class EnergyTransferEvent
    extends Event {
        public final EnergyNetwork energyNetwork;
        public final double power;

        public EnergyTransferEvent(EnergyNetwork network, double currentPower) {
            this.energyNetwork = network;
            this.power = currentPower;
        }
    }
}

