/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters;

import java.util.Collection;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.Transmitter;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TransmitterImpl<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, BUFFER>, BUFFER>
extends Transmitter<ACCEPTOR, NETWORK, BUFFER> {
    public TileEntityTransmitter<ACCEPTOR, NETWORK, BUFFER> containingTile;

    public TransmitterImpl(TileEntityTransmitter<ACCEPTOR, NETWORK, BUFFER> multiPart) {
        this.setTileEntity(multiPart);
    }

    @Override
    public int getCapacity() {
        return this.getTileEntity().getCapacity();
    }

    @Override
    public World world() {
        return this.getTileEntity().func_145831_w();
    }

    @Override
    public Coord4D coord() {
        return new Coord4D(this.getTileEntity().func_174877_v(), this.getTileEntity().func_145831_w());
    }

    @Override
    public Coord4D getAdjacentConnectableTransmitterCoord(EnumFacing side) {
        IGridTransmitter transmitter;
        Coord4D sideCoord = this.coord().offset(side);
        TileEntity potentialTransmitterTile = sideCoord.getTileEntity((IBlockAccess)this.world());
        if (!this.containingTile.canConnectMutual(side)) {
            return null;
        }
        if (CapabilityUtils.hasCapability((ICapabilityProvider)potentialTransmitterTile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()) && TransmissionType.checkTransmissionType(transmitter = CapabilityUtils.getCapability((ICapabilityProvider)potentialTransmitterTile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()), this.getTransmissionType()) && this.containingTile.isValidTransmitter(potentialTransmitterTile)) {
            return sideCoord;
        }
        return null;
    }

    @Override
    public boolean isCompatibleWith(IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> other) {
        if (other instanceof TransmitterImpl) {
            TransmitterImpl transmitter = (TransmitterImpl)other;
            return this.containingTile.isValidTransmitter(transmitter.containingTile);
        }
        return true;
    }

    @Override
    public void connectionFailed() {
        this.containingTile.delayedRefresh = true;
    }

    @Override
    public ACCEPTOR getAcceptor(EnumFacing side) {
        return this.getTileEntity().getCachedAcceptor(side);
    }

    @Override
    public boolean isValid() {
        TileEntityTransmitter<ACCEPTOR, NETWORK, BUFFER> cont = this.getTileEntity();
        if (cont == null) {
            return false;
        }
        return !cont.func_145837_r() && this.coord().exists(this.world()) && this.coord().getTileEntity((IBlockAccess)this.world()) == cont && cont.getTransmitter() == this;
    }

    @Override
    public NETWORK createEmptyNetwork() {
        return this.getTileEntity().createNewNetwork();
    }

    @Override
    public NETWORK getExternalNetwork(Coord4D from) {
        IGridTransmitter transmitter;
        TileEntity tile = from.getTileEntity((IBlockAccess)this.world());
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null) && TransmissionType.checkTransmissionType(transmitter = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null), this.getTransmissionType())) {
            return transmitter.getTransmitterNetwork();
        }
        return null;
    }

    @Override
    public void takeShare() {
        this.containingTile.takeShare();
    }

    @Override
    public void updateShare() {
        this.containingTile.updateShare();
    }

    @Override
    @Nullable
    public BUFFER getBuffer() {
        return this.getTileEntity().getBuffer();
    }

    @Override
    @Nullable
    public BUFFER getBufferWithFallback() {
        return this.getTileEntity().getBufferWithFallback();
    }

    @Override
    public NETWORK mergeNetworks(Collection<NETWORK> toMerge) {
        return this.getTileEntity().createNetworkByMerging(toMerge);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return this.getTileEntity().getTransmissionType();
    }

    @Override
    public void setRequestsUpdate() {
        this.containingTile.sendDesc = true;
    }

    public TileEntityTransmitter<ACCEPTOR, NETWORK, BUFFER> getTileEntity() {
        return this.containingTile;
    }

    public void setTileEntity(TileEntityTransmitter<ACCEPTOR, NETWORK, BUFFER> containingPart) {
        this.containingTile = containingPart;
    }
}

