/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.IAlloyInteraction;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.tier.AlloyTier;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityTransmitter<A, N extends DynamicNetwork<A, N, BUFFER>, BUFFER>
extends TileEntitySidedPipe
implements IAlloyInteraction {
    public TransmitterImpl<A, N, BUFFER> transmitterDelegate = new TransmitterImpl(this);
    public boolean unloaded = true;
    public boolean dataRequest = false;
    public boolean delayedRefresh = false;
    private N lastClientNetwork = null;

    public TransmitterImpl<A, N, BUFFER> getTransmitter() {
        return this.transmitterDelegate;
    }

    public abstract N createNewNetwork();

    public abstract N createNetworkByMerging(Collection<N> var1);

    @Override
    public void onWorldJoin() {
        if (!this.func_145831_w().field_72995_K) {
            TransmitterNetworkRegistry.registerOrphanTransmitter(this.getTransmitter());
        } else if (this.lastClientNetwork != null) {
            this.getTransmitter().setTransmitterNetwork(this.lastClientNetwork);
        }
        this.unloaded = false;
    }

    @Override
    public void doRestrictedTick() {
        super.doRestrictedTick();
        if (this.delayedRefresh) {
            this.delayedRefresh = false;
            this.refreshConnections();
        }
        if (this.func_145831_w().field_72995_K && !this.dataRequest) {
            this.dataRequest = true;
            MinecraftForge.EVENT_BUS.post((Event)new DynamicNetwork.NetworkClientRequest(this.func_145831_w().func_175625_s(this.func_174877_v())));
        }
    }

    @Override
    public void onChunkUnload() {
        if (!this.func_145831_w().field_72995_K) {
            this.getTransmitter().takeShare();
        }
        super.onChunkUnload();
    }

    @Override
    public void onWorldSeparate() {
        this.unloaded = true;
        if (!this.func_145831_w().field_72995_K) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        } else {
            this.lastClientNetwork = this.getTransmitter().getTransmitterNetwork();
            this.getTransmitter().setTransmitterNetwork(null);
        }
    }

    @Override
    public void markDirtyTransmitters() {
        super.markDirtyTransmitters();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    @Override
    public void markDirtyAcceptor(EnumFacing side) {
        super.markDirtyAcceptor(side);
        if (this.getTransmitter().hasTransmitterNetwork()) {
            ((DynamicNetwork)this.getTransmitter().getTransmitterNetwork()).acceptorChanged(this.getTransmitter(), side);
        }
    }

    protected boolean canHaveIncompatibleNetworks() {
        return false;
    }

    @Override
    protected void recheckConnections(byte newlyEnabledTransmitters) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            if (this.canHaveIncompatibleNetworks()) {
                boolean networkUpdated = false;
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    if (!TileEntityTransmitter.connectionMapContainsSide(newlyEnabledTransmitters, side)) continue;
                    networkUpdated |= this.recheckConnectionPrechecked(side);
                }
                if (networkUpdated) {
                    this.refreshNetwork();
                }
            }
        } else {
            super.recheckConnections(newlyEnabledTransmitters);
        }
    }

    @Override
    protected void recheckConnection(EnumFacing side) {
        if (this.canHaveIncompatibleNetworks() && this.getTransmitter().hasTransmitterNetwork() && this.recheckConnectionPrechecked(side)) {
            this.refreshNetwork();
        }
    }

    private void refreshNetwork() {
        IGridTransmitter[] transmitters;
        Object network = this.getTransmitter().getTransmitterNetwork();
        ((DynamicNetwork)network).queueClientUpdate(((DynamicNetwork)network).getTransmitters());
        for (IGridTransmitter transmitter : transmitters = ((DynamicNetwork)network).getTransmitters().toArray(new IGridTransmitter[0])) {
            if (!(transmitter instanceof TransmitterImpl)) continue;
            TransmitterImpl imp = (TransmitterImpl)transmitter;
            imp.containingTile.refreshConnections();
        }
    }

    private boolean recheckConnectionPrechecked(EnumFacing side) {
        TileEntity tileEntity = MekanismUtils.getTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(side));
        if (tileEntity instanceof TileEntityTransmitter) {
            Object otherNetwork;
            TileEntityTransmitter other = (TileEntityTransmitter)tileEntity;
            Object network = this.getTransmitter().getTransmitterNetwork();
            if (other.canHaveIncompatibleNetworks() && other.getTransmitter().hasTransmitterNetwork() && network != (otherNetwork = other.getTransmitter().getTransmitterNetwork()) && ((DynamicNetwork)network).isCompatibleWith(otherNetwork)) {
                if (this.getBufferWithFallback() == null) {
                    Object tempNetwork = network;
                    network = otherNetwork;
                    otherNetwork = tempNetwork;
                }
                ((DynamicNetwork)network).adoptTransmittersAndAcceptorsFrom(otherNetwork);
                ((DynamicNetwork)otherNetwork).deregister();
                ((DynamicNetwork)network).commit();
                ((DynamicNetwork)network).updateCapacity();
                ((DynamicNetwork)network).clampBuffer();
                return true;
            }
        }
        return false;
    }

    public abstract A getCachedAcceptor(EnumFacing var1);

    protected TileEntity getCachedTile(EnumFacing side) {
        TileEntitySidedPipe.ConnectionType type = this.connectionTypes[side.ordinal()];
        if (type == TileEntitySidedPipe.ConnectionType.PULL || type == TileEntitySidedPipe.ConnectionType.NONE) {
            return null;
        }
        return TileEntityTransmitter.connectionMapContainsSide(this.currentAcceptorConnections, side) ? this.cachedAcceptors[side.ordinal()] : null;
    }

    @Override
    public void onAlloyInteraction(EntityPlayer player, ItemStack stack, @NotNull AlloyTier tierOrdinal) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            int upgraded = 0;
            ArrayList list = new ArrayList(((DynamicNetwork)this.getTransmitter().getTransmitterNetwork()).getTransmitters());
            list.sort((o1, o2) -> {
                if (o1 != null && o2 != null) {
                    Coord4D thisCoord = new Coord4D(this.func_174877_v(), this.func_145831_w());
                    Coord4D o1Coord = o1.coord();
                    Coord4D o2Coord = o2.coord();
                    return Integer.compare(o1Coord.distanceTo(thisCoord), o2Coord.distanceTo(thisCoord));
                }
                return 0;
            });
            for (IGridTransmitter iGridTransmitter : list) {
                if (!(iGridTransmitter instanceof TransmitterImpl)) continue;
                TransmitterImpl transmitter = (TransmitterImpl)iGridTransmitter;
                TileEntityTransmitter t = transmitter.containingTile;
                if (!t.upgrade(tierOrdinal) || ++upgraded != 8) continue;
                break;
            }
            if (upgraded > 0 && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
    }

    public boolean upgrade(AlloyTier tierOrdinal) {
        return false;
    }

    public abstract int getCapacity();

    @Nullable
    public abstract BUFFER getBuffer();

    @Nullable
    public BUFFER getBufferWithFallback() {
        BUFFER buffer = this.getBuffer();
        if (buffer == null && this.getTransmitter().hasTransmitterNetwork()) {
            return ((DynamicNetwork)this.getTransmitter().getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    public abstract void takeShare();

    public abstract void updateShare();

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GRID_TRANSMITTER_CAPABILITY || capability == Capabilities.ALLOY_INTERACTION_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GRID_TRANSMITTER_CAPABILITY) {
            return (T)Capabilities.GRID_TRANSMITTER_CAPABILITY.cast(this.getTransmitter());
        }
        if (capability == Capabilities.ALLOY_INTERACTION_CAPABILITY) {
            return (T)Capabilities.ALLOY_INTERACTION_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }
}

