/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import io.netty.buffer.ByteBuf;
import mekanism.api.TileNetworkList;
import mekanism.common.Upgrade;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class TileEntityOperationalMachine
extends TileEntityMachine
implements IComparatorSupport {
    public int operatingTicks;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired;

    protected TileEntityOperationalMachine(String sound, BlockStateMachine.MachineType type, int upgradeSlot, int baseTicksRequired) {
        super(sound, type, upgradeSlot);
        this.ticksRequired = this.BASE_TICKS_REQUIRED = baseTicksRequired;
    }

    public double getScaledProgress() {
        return Math.min((double)this.operatingTicks / (double)this.ticksRequired, 1.0);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.operatingTicks = dataStream.readInt();
            this.ticksRequired = dataStream.readInt();
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && MekanismConfig.current().mekce.EnableUpgradeConfigure.val()) {
            MekanismUtils.inject.accept(this.ticksRequired, this::onUpdate);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.operatingTicks);
        data.add(this.ticksRequired);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                break;
            }
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                break;
            }
        }
    }

    @Override
    public int getRedstoneLevel() {
        return Container.func_94526_b((IInventory)this);
    }
}

