/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import javax.annotation.Nonnull;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.SideData;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.prefab.TileEntityUpgradeableMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TileEntityDoubleElectricMachine<RECIPE extends DoubleMachineRecipe<RECIPE>>
extends TileEntityUpgradeableMachine<DoubleMachineInput, ItemStackOutput, RECIPE> {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};

    public TileEntityDoubleElectricMachine(String soundPath, BlockStateMachine.MachineType type, int ticksRequired) {
        super(soundPath, type, 4, ticksRequired);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{3}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.EXTRA, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_EXTRA, new int[]{1, 0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(new int[]{0, 2}, new boolean[]{false, true}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_ENHANCED, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_ENHANCED_OUTPUT_ENHANCED, new int[]{0, 2}, new boolean[]{false, true}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{4, 1, 1, 3, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullListSynchronized.withSize(5, ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.ejectorComponent.setInputOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(6));
    }

    @Override
    protected void upgradeInventory(TileEntityFactory factory) {
        factory.inventory.set(5, (ItemStack)this.inventory.get(0));
        factory.inventory.set(4, (ItemStack)this.inventory.get(1));
        factory.inventory.set(8, (ItemStack)this.inventory.get(2));
        factory.inventory.set(1, (ItemStack)this.inventory.get(3));
        factory.inventory.set(0, (ItemStack)this.inventory.get(4));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(3, this);
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> {
                this.AutomaticallyExtractItems(7, 0);
                this.AutomaticallyExtractItems(8, 0);
                this.BetterEjectingItem(8, 2);
            });
            boolean inactive = false;
            MachineRecipe recipe = this.getRecipe();
            if (this.canOperate((RECIPE)recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                ++this.operatingTicks;
                if (this.operatingTicks >= this.ticksRequired) {
                    this.operate((RECIPE)recipe);
                    this.operatingTicks = 0;
                }
                this.electricityStored.addAndGet(-this.energyPerTick);
            } else {
                inactive = true;
                this.setActive(false);
            }
            if (inactive && this.getRecipe() == null) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        block6: {
            block5: {
                if (slotID == 2) {
                    return false;
                }
                if (slotID == 4) {
                    return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
                }
                if (slotID != 0) break block5;
                for (DoubleMachineInput input : this.getRecipes().keySet()) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemStack, (ItemStack)itemstack)) continue;
                    return true;
                }
                break block6;
            }
            if (slotID == 3) {
                return ChargeUtils.canBeDischarged(itemstack);
            }
            if (slotID != 1) break block6;
            for (DoubleMachineInput input : this.getRecipes().keySet()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)input.extraStack, (ItemStack)itemstack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DoubleMachineInput getInput() {
        return new DoubleMachineInput((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1));
    }

    @Override
    public RECIPE getRecipe() {
        DoubleMachineInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((DoubleMachineInput)((DoubleMachineRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getRecipe(input, this.getRecipes());
        }
        return (RECIPE)((DoubleMachineRecipe)this.cachedRecipe);
    }

    @Override
    public void operate(RECIPE recipe) {
        ((DoubleMachineRecipe)recipe).operate(this.inventory, 0, 1, 2);
        this.markNoUpdateSync();
    }

    @Override
    public boolean canOperate(RECIPE recipe) {
        return recipe != null && ((DoubleMachineRecipe)recipe).canOperate(this.inventory, 0, 1, 2);
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getEnergy();
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.operatingTicks;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.isActive;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.facing;
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = this.canOperate((RECIPE)this.getRecipe());
                break;
            }
            case 5: {
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = this.maxEnergy;
                break;
            }
            case 6: {
                Object[] objectArray8 = new Object[1];
                objectArray = objectArray8;
                objectArray8[0] = this.maxEnergy - this.getEnergy();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }
}

