/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import java.util.Iterator;
import javax.annotation.Nonnull;
import mekanism.common.Upgrade;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ItemHandlerWrapper;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.capabilities.IToggleableCapability;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class TileEntityContainerBlock
extends TileEntityBasicBlock
implements ISidedInventory,
ISustainedInventory,
IToggleableCapability {
    public NonNullListSynchronized<ItemStack> inventory;
    public String fullName;
    private CapabilityWrapperManager<ISidedInventory, ItemHandlerWrapper> itemManager = new CapabilityWrapperManager<ISidedInventory, ItemHandlerWrapper>(ISidedInventory.class, ItemHandlerWrapper.class);
    private IItemHandler nullHandler = new InvWrapper((IInventory)this){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }
    };

    public TileEntityContainerBlock(String name) {
        this.fullName = name;
    }

    public boolean func_191420_l() {
        Iterator iterator = this.getInventory().iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        if (this.handleInventory()) {
            NBTTagList tagList = nbtTags.func_150295_c("Items", 10);
            this.inventory = NonNullListSynchronized.withSize(this.func_70302_i_(), ItemStack.field_190927_a);
            for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
                NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
                byte slotID = tagCompound.func_74771_c("Slot");
                if (slotID < 0 || slotID >= this.func_70302_i_()) continue;
                this.func_70299_a(slotID, new ItemStack(tagCompound));
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        if (this.handleInventory()) {
            NBTTagList tagList = new NBTTagList();
            for (int slotCount = 0; slotCount < this.func_70302_i_(); ++slotCount) {
                ItemStack stackInSlot = this.func_70301_a(slotCount);
                if (stackInSlot.func_190926_b()) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)slotCount);
                stackInSlot.func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            nbtTags.func_74782_a("Items", (NBTBase)tagList);
        }
    }

    protected NonNullListSynchronized<ItemStack> getInventory() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return this.getInventory() != null ? this.getInventory().size() : 0;
    }

    @Nonnull
    public ItemStack func_70301_a(int slotID) {
        return this.getInventory() != null ? this.getInventory().get(slotID) : ItemStack.field_190927_a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ItemStack func_70298_a(int slotID, int amount) {
        NonNullListSynchronized<ItemStack> nonNullListSynchronized = this.inventory;
        synchronized (nonNullListSynchronized) {
            if (this.getInventory() == null) {
                return ItemStack.field_190927_a;
            }
            return ItemStackHelper.func_188382_a(this.getInventory(), (int)slotID, (int)amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ItemStack func_70304_b(int slotID) {
        NonNullListSynchronized<ItemStack> nonNullListSynchronized = this.inventory;
        synchronized (nonNullListSynchronized) {
            if (this.getInventory() == null) {
                return ItemStack.field_190927_a;
            }
            return ItemStackHelper.func_188383_a(this.getInventory(), (int)slotID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int slotID, @Nonnull ItemStack itemstack) {
        NonNullListSynchronized<ItemStack> nonNullListSynchronized = this.inventory;
        synchronized (nonNullListSynchronized) {
            this.getInventory().set(slotID, itemstack);
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
                itemstack.func_190920_e(this.func_70297_j_());
            }
            this.markNoUpdateSync();
        }
    }

    public boolean func_70300_a(@Nonnull EntityPlayer entityplayer) {
        return !this.func_145837_r() && this.field_145850_b.func_175667_e(this.field_174879_c);
    }

    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize(this.func_145838_q().func_149739_a() + "." + this.fullName + ".name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        return true;
    }

    public boolean func_180462_a(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    @Nonnull
    public abstract int[] func_180463_a(@Nonnull EnumFacing var1);

    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        return true;
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (nbtTags == null || nbtTags.func_74745_c() == 0 || !this.handleInventory()) {
            return;
        }
        this.inventory = NonNullListSynchronized.withSize(this.func_70302_i_(), ItemStack.field_190927_a);
        for (int slots = 0; slots < nbtTags.func_74745_c(); ++slots) {
            NBTTagCompound tagCompound = nbtTags.func_150305_b(slots);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.size()) continue;
            this.inventory.set(slotID, new ItemStack(tagCompound));
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        NBTTagList tagList = new NBTTagList();
        if (this.handleInventory()) {
            for (int slots = 0; slots < this.inventory.size(); ++slots) {
                if (this.inventory.get(slots).func_190926_b()) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)slots);
                this.inventory.get(slots).func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
        }
        return tagList;
    }

    public boolean handleInventory() {
        return true;
    }

    public void recalculateUpgradables(Upgrade upgradeType) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemHandler(side));
        }
        return super.getCapability(capability, side);
    }

    protected IItemHandler getItemHandler(EnumFacing side) {
        return side == null ? this.nullHandler : (IItemHandler)this.itemManager.getWrapper(this, side);
    }
}

