/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import javax.annotation.Nonnull;
import mekanism.api.IConfigCardAccess;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.base.IElectricMachine;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.tile.component.SideConfig;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityOperationalMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityBasicMachine<INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, OUTPUT, RECIPE>>
extends TileEntityOperationalMachine
implements IElectricMachine<INPUT, OUTPUT, RECIPE>,
IComputerIntegration,
ISideConfiguration,
IConfigCardAccess {
    protected int successCounter = 0;
    protected boolean inventoryChanged = false;
    public RECIPE cachedRecipe = null;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;

    public TileEntityBasicMachine(String soundPath, BlockStateMachine.MachineType type, int upgradeSlot, int baseTicksRequired) {
        super("machine." + soundPath, type, upgradeSlot, baseTicksRequired);
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.configComponent.hasSideForData(TransmissionType.ENERGY, this.facing, 1, side);
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.CONFIG_CARD_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY) {
            return (T)Capabilities.CONFIG_CARD_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        return this.configComponent.isCapabilityDisabled(capability, side, this.facing) || super.isCapabilityDisabled(capability, side);
    }

    protected void AutomaticallyExtractItems(int dataIndex, int inputSlotID) {
        if (this.func_145831_w().field_72995_K || !this.canWork(5, 60)) {
            return;
        }
        this.InputItems(dataIndex, inputSlotID);
    }

    protected void BetterEjectingItem(int dataIndex, int outputSlotID) {
        if (this.func_145831_w().field_72995_K || !this.canWork(5, 60)) {
            return;
        }
        this.outputItems(dataIndex, outputSlotID);
    }

    private void outputItems(int dataIndex, int outputSlotID) {
        SideConfig config = this.configComponent.getConfig(TransmissionType.ITEM);
        EnumFacing[] translatedFacings = MekanismUtils.getBaseOrientations(this.facing);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IItemHandler itemHandler;
            if (config.get(translatedFacings[facing.ordinal()]) != dataIndex) continue;
            BlockPos offset = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(offset);
            if (te == null || (itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) == null) continue;
            try {
                this.outputToExternal(itemHandler, outputSlotID);
            }
            catch (Exception e) {
                Mekanism.logger.error("Exception when insert item: ", (Throwable)e);
            }
        }
    }

    private synchronized void outputToExternal(IItemHandler external, int outputSlotID) {
        for (int externalSlotId = 0; externalSlotId < external.getSlots() && this.configComponent.isEjecting(TransmissionType.ITEM); ++externalSlotId) {
            ItemStack notInserted;
            ItemStack internalStack;
            ItemStack externalStack = external.getStackInSlot(externalSlotId);
            int slotLimit = external.getSlotLimit(externalSlotId);
            if (!externalStack.func_190926_b() && externalStack.func_190916_E() >= slotLimit || (internalStack = (ItemStack)this.inventory.get(outputSlotID)).func_190926_b()) continue;
            if (externalStack.func_190926_b()) {
                notInserted = external.insertItem(externalSlotId, internalStack, false);
                if (notInserted.func_190916_E() == internalStack.func_190916_E()) break;
                this.inventory.set(outputSlotID, notInserted);
                if (!notInserted.func_190926_b()) continue;
                break;
            }
            if (!TileEntityBasicMachine.matchStacks(internalStack, externalStack)) continue;
            notInserted = external.insertItem(externalSlotId, internalStack, false);
            this.inventory.set(outputSlotID, notInserted);
            if (notInserted.func_190926_b()) break;
        }
    }

    private void InputItems(int dataIndex, int inputSlotID) {
        SideConfig config = this.configComponent.getConfig(TransmissionType.ITEM);
        EnumFacing[] translatedFacings = MekanismUtils.getBaseOrientations(this.facing);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IItemHandler itemHandler;
            if (config.get(translatedFacings[facing.ordinal()]) != dataIndex) continue;
            BlockPos offset = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(offset);
            if (te == null || (itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) == null) continue;
            this.inputFromExternal(itemHandler, inputSlotID);
        }
    }

    private synchronized void inputFromExternal(IItemHandler external, int inputSlotID) {
        boolean successAtLeastOnce = false;
        for (int externalSlotId = 0; externalSlotId < external.getSlots(); ++externalSlotId) {
            ItemStack externalStack = external.getStackInSlot(externalSlotId);
            if (externalStack.func_190926_b()) continue;
            ItemStack internalStack = (ItemStack)this.inventory.get(inputSlotID);
            int maxCanExtract = Math.min(externalStack.func_190916_E(), externalStack.func_77976_d());
            if (internalStack.func_190926_b()) {
                ItemStack extracted = external.extractItem(externalSlotId, maxCanExtract, false);
                this.inventory.set(inputSlotID, extracted);
                successAtLeastOnce = true;
                if (!external.getStackInSlot(externalSlotId).func_190926_b()) continue;
                continue;
            }
            if (internalStack.func_190916_E() >= internalStack.func_77976_d() || !TileEntityBasicMachine.matchStacks(internalStack, externalStack)) continue;
            int extractAmt = Math.min(internalStack.func_77976_d() - internalStack.func_190916_E(), maxCanExtract);
            ItemStack extracted = external.extractItem(externalSlotId, extractAmt, false);
            this.inventory.set(inputSlotID, TileEntityBasicMachine.copyStackWithSize(extracted, internalStack.func_190916_E() + extracted.func_190916_E()));
            successAtLeastOnce = true;
            if (!external.getStackInSlot(externalSlotId).func_190926_b()) continue;
        }
        if (successAtLeastOnce) {
            this.incrementSuccessCounter(60, 5);
            this.markNoUpdate();
        } else {
            this.decrementSuccessCounter();
        }
    }

    public static ItemStack copyStackWithSize(ItemStack stack, int amount) {
        if (stack.func_190926_b() || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = stack.func_77946_l();
        s.func_190920_e(amount);
        return s;
    }

    public static boolean matchStacks(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)other)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    protected boolean canWork(int minWorkDelay, int maxWorkDelay) {
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            return true;
        }
        if (this.successCounter <= 0) {
            return this.ticksExisted % maxWorkDelay == 0;
        }
        int workDelay = Math.max(minWorkDelay, maxWorkDelay - this.successCounter * 5);
        return this.ticksExisted % workDelay == 0;
    }

    protected void incrementSuccessCounter(int maxWorkDelay, int minWorkDelay) {
        int max = (maxWorkDelay - minWorkDelay) / 5;
        if (this.successCounter < max) {
            ++this.successCounter;
        }
    }

    protected void decrementSuccessCounter() {
        if (this.successCounter > 0) {
            --this.successCounter;
        }
    }
}

