/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationController;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityThermalEvaporationBlock
extends TileEntityContainerBlock
implements IComputerIntegration {
    private static final String[] methods = new String[]{"getTemperature", "getHeight", "isFormed", "getInput", "getOutput"};
    public Coord4D master;
    public boolean attempted;

    public TileEntityThermalEvaporationBlock() {
        super("ThermalEvaporationBlock");
        this.inventory = NonNullListSynchronized.withSize(0, ItemStack.field_190927_a);
    }

    public TileEntityThermalEvaporationBlock(String fullName) {
        super(fullName);
        this.inventory = NonNullListSynchronized.withSize(0, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K && this.ticker == 5 && !this.attempted && this.master == null) {
            this.updateController();
        }
        this.attempted = false;
    }

    @Override
    public boolean supportsAsync() {
        return false;
    }

    public void addToStructure(Coord4D controller) {
        this.master = controller;
    }

    public void controllerGone() {
        this.master = null;
    }

    public void onChunkUnload() {
        TileEntityThermalEvaporationController tile;
        super.onChunkUnload();
        if (this.master != null && (tile = this.getController()) != null) {
            tile.refresh();
        }
    }

    @Override
    public void onNeighborChange(Block block) {
        super.onNeighborChange(block);
        if (!this.field_145850_b.field_72995_K) {
            TileEntityThermalEvaporationController tile = this.getController();
            if (tile != null) {
                tile.refresh();
            } else {
                this.updateController();
            }
        }
    }

    public void updateController() {
        if (!(this instanceof TileEntityThermalEvaporationController)) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                BlockPos checkPos = this.field_174879_c.func_177972_a(side);
                TileEntity check = MekanismUtils.getTileEntity(this.field_145850_b, checkPos);
                if (!(check instanceof TileEntityThermalEvaporationBlock) || !(check instanceof TileEntityThermalEvaporationController)) continue;
                TileEntityThermalEvaporationController controller = (TileEntityThermalEvaporationController)check;
                controller.refresh();
                return;
            }
            TileEntityThermalEvaporationController found = new ControllerFinder().find();
            if (found != null) {
                found.refresh();
            }
        }
    }

    public TileEntityThermalEvaporationController getController() {
        TileEntity tile;
        if (this.master != null && (tile = this.master.getTileEntity((IBlockAccess)this.field_145850_b)) instanceof TileEntityThermalEvaporationController) {
            TileEntityThermalEvaporationController controller = (TileEntityThermalEvaporationController)tile;
            return controller;
        }
        return null;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        Object[] objectArray;
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller == null) {
            return new Object[]{"Unformed."};
        }
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = Float.valueOf(controller.temperature);
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = controller.height;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = controller.structured;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = controller.inputTank.getFluidAmount();
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = controller.outputTank.getFluidAmount();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    public class ControllerFinder {
        public TileEntityThermalEvaporationController found;
        public Set<BlockPos> iterated = new ObjectOpenHashSet();
        private Deque<BlockPos> checkQueue = new LinkedList<BlockPos>();

        public void loop(BlockPos startPos) {
            this.checkQueue.add(startPos);
            while (this.checkQueue.peek() != null) {
                BlockPos checkPos = this.checkQueue.pop();
                if (this.iterated.contains(checkPos)) continue;
                this.iterated.add(checkPos);
                TileEntity te = MekanismUtils.getTileEntity(TileEntityThermalEvaporationBlock.this.field_145850_b, checkPos);
                if (te instanceof TileEntityThermalEvaporationController) {
                    TileEntityThermalEvaporationController controller;
                    this.found = controller = (TileEntityThermalEvaporationController)te;
                    return;
                }
                if (!(te instanceof TileEntityThermalEvaporationBlock)) continue;
                TileEntityThermalEvaporationBlock block = (TileEntityThermalEvaporationBlock)te;
                block.attempted = true;
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    BlockPos coord = checkPos.func_177972_a(side);
                    if (this.iterated.contains(coord)) continue;
                    this.checkQueue.addLast(coord);
                }
            }
        }

        public TileEntityThermalEvaporationController find() {
            this.loop(TileEntityThermalEvaporationBlock.this.field_174879_c);
            return this.found;
        }
    }
}

