/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityMultiblock<T extends SynchronizedData<T>>
extends TileEntityContainerBlock
implements IMultiblock<T> {
    @Nullable
    public T structure;
    public boolean sendStructure;
    public boolean prevStructure;
    public boolean clientHasStructure;
    public boolean isRendering;
    public MultiblockCache<T> cachedData = this.getNewCache();
    @Nullable
    public String cachedID = null;

    public TileEntityMultiblock(String name) {
        super(name);
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            if (this.structure == null) {
                this.structure = this.getNewStructure();
            }
            if (this.structure != null && ((SynchronizedData)this.structure).renderLocation != null && this.clientHasStructure && this.isRendering && !this.prevStructure) {
                Mekanism.proxy.doMultiblockSparkle(this, ((SynchronizedData)this.structure).renderLocation.getPos(), ((SynchronizedData)this.structure).volLength, ((SynchronizedData)this.structure).volWidth, ((SynchronizedData)this.structure).volHeight, tile -> MultiblockManager.areEqual(this, tile));
            }
            this.prevStructure = this.clientHasStructure;
        }
        if (this.playersUsing.size() > 0 && (this.field_145850_b.field_72995_K && !this.clientHasStructure || !this.field_145850_b.field_72995_K && this.structure == null)) {
            for (EntityPlayer player : this.playersUsing) {
                player.func_71053_j();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.structure == null) {
                this.isRendering = false;
                if (this.cachedID != null) {
                    this.getManager().updateCache(this);
                }
                if (this.ticker == 5) {
                    this.doUpdate();
                }
            }
            if (this.prevStructure == (this.structure == null)) {
                if (this.structure != null && !((SynchronizedData)this.structure).hasRenderer) {
                    ((SynchronizedData)this.structure).hasRenderer = true;
                    this.isRendering = true;
                    this.sendStructure = true;
                }
                Coord4D thisCoord = Coord4D.get(this);
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    Coord4D obj = thisCoord.offset(side);
                    if (this.structure != null && (((SynchronizedData)this.structure).locations.contains(obj) || ((SynchronizedData)this.structure).internalLocations.contains(obj))) continue;
                    TileEntity tile2 = obj.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (obj.isAirBlock((IBlockAccess)this.field_145850_b) || tile2 != null && tile2.getClass() == this.getClass() || tile2 instanceof IStructuralMultiblock || tile2 instanceof IMultiblock) continue;
                    Mekanism.EXECUTE_MANAGER.addSyncTask(() -> MekanismUtils.notifyNeighborofChange(this.field_145850_b, obj, this.func_174877_v()));
                }
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            boolean bl = this.prevStructure = this.structure != null;
            if (this.structure != null) {
                ((SynchronizedData)this.structure).didTick = false;
                if (((SynchronizedData)this.structure).inventoryID != null) {
                    this.cachedData.sync(this.structure);
                    this.cachedID = ((SynchronizedData)this.structure).inventoryID;
                    this.getManager().updateCache(this);
                }
            }
        }
    }

    @Override
    public boolean supportsAsync() {
        return false;
    }

    @Override
    public void doUpdate() {
        if (!(this.field_145850_b.field_72995_K || this.structure != null && ((SynchronizedData)this.structure).didTick)) {
            this.getProtocol().doUpdate();
            if (this.structure != null) {
                ((SynchronizedData)this.structure).didTick = true;
            }
        }
    }

    public void sendPacketToRenderer() {
        if (this.structure != null) {
            for (Coord4D obj : ((SynchronizedData)this.structure).locations) {
                TileEntityMultiblock tileEntity = (TileEntityMultiblock)obj.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity == null || !tileEntity.isRendering) continue;
                Mekanism.packetHandler.sendUpdatePacket(tileEntity);
            }
        }
    }

    protected abstract T getNewStructure();

    public abstract MultiblockCache<T> getNewCache();

    protected abstract UpdateProtocol<T> getProtocol();

    public abstract MultiblockManager<T> getManager();

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.isRendering);
        data.add(this.structure != null);
        if (this.structure != null && this.isRendering) {
            if (this.sendStructure) {
                this.sendStructure = false;
                data.add(true);
                data.add(((SynchronizedData)this.structure).volHeight);
                data.add(((SynchronizedData)this.structure).volWidth);
                data.add(((SynchronizedData)this.structure).volLength);
                ((SynchronizedData)this.structure).renderLocation.write(data);
                data.add(((SynchronizedData)this.structure).inventoryID != null);
                if (((SynchronizedData)this.structure).inventoryID != null) {
                    data.add(((SynchronizedData)this.structure).inventoryID);
                }
            } else {
                data.add(false);
            }
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (this.structure == null) {
                this.structure = this.getNewStructure();
            }
            this.isRendering = dataStream.readBoolean();
            this.clientHasStructure = dataStream.readBoolean();
            if (this.clientHasStructure && this.isRendering && dataStream.readBoolean()) {
                ((SynchronizedData)this.structure).volHeight = dataStream.readInt();
                ((SynchronizedData)this.structure).volWidth = dataStream.readInt();
                ((SynchronizedData)this.structure).volLength = dataStream.readInt();
                ((SynchronizedData)this.structure).renderLocation = Coord4D.read(dataStream);
                ((SynchronizedData)this.structure).inventoryID = dataStream.readBoolean() ? PacketHandler.readString(dataStream) : null;
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        if (this.structure == null && nbtTags.func_74764_b("cachedID")) {
            this.cachedID = nbtTags.func_74779_i("cachedID");
            this.cachedData.load(nbtTags);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        if (this.cachedID != null) {
            nbtTags.func_74778_a("cachedID", this.cachedID);
            this.cachedData.save(nbtTags);
        }
    }

    @Override
    protected NonNullListSynchronized<ItemStack> getInventory() {
        return this.structure != null ? ((SynchronizedData)this.structure).getInventory() : null;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean handleInventory() {
        return false;
    }

    @Override
    public T getSynchronizedData() {
        return this.structure;
    }
}

