/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.matrix.MatrixCache;
import mekanism.common.content.matrix.MatrixUpdateProtocol;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.tile.multiblock.TileEntityMultiblock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityInductionCasing
extends TileEntityMultiblock<SynchronizedMatrixData>
implements IStrictEnergyStorage,
IComputerIntegration {
    protected static final int[] CHARGE_SLOT = new int[]{0};
    protected static final int[] DISCHARGE_SLOT = new int[]{1};
    public static final String[] methods = new String[]{"getEnergy", "getMaxEnergy", "getInput", "getOutput", "getTransferCap"};

    public TileEntityInductionCasing() {
        this("InductionCasing");
    }

    public TileEntityInductionCasing(String name) {
        super(name);
        this.inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.structure != null && this.isRendering) {
            ((SynchronizedMatrixData)this.structure).tick(this.field_145850_b);
            ChargeUtils.charge(0, (IStrictEnergyStorage)this);
            ChargeUtils.discharge(1, this);
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.func_70093_af() && this.structure != null) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            player.openGui((Object)Mekanism.instance, 49, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            ((SynchronizedMatrixData)this.structure).addStructureData(data);
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.clientHasStructure) {
            ((SynchronizedMatrixData)this.structure).readStructureData(dataStream);
        }
    }

    @Override
    protected SynchronizedMatrixData getNewStructure() {
        return new SynchronizedMatrixData();
    }

    public MatrixCache getNewCache() {
        return new MatrixCache();
    }

    protected MatrixUpdateProtocol getProtocol() {
        return new MatrixUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedMatrixData> getManager() {
        return Mekanism.matrixManager;
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize("gui.inductionMatrix");
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.getEnergy() * (double)i / this.getMaxEnergy());
    }

    @Override
    public double getEnergy() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).getEnergyPostQueue() : 0.0;
    }

    @Override
    public void setEnergy(double energy) {
        if (this.structure != null) {
            ((SynchronizedMatrixData)this.structure).queueSetEnergy(Math.max(Math.min(energy, this.getMaxEnergy()), 0.0));
        }
    }

    public double addEnergy(double energy, boolean simulate) {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).queueEnergyAddition(energy, simulate) : 0.0;
    }

    public double removeEnergy(double energy, boolean simulate) {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).queueEnergyRemoval(energy, simulate) : 0.0;
    }

    @Override
    public double getMaxEnergy() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).getStorageCap() : 0.0;
    }

    public double getLastInput() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).getLastInput() : 0.0;
    }

    public double getLastOutput() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).getLastOutput() : 0.0;
    }

    public double getTransferCap() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).getTransferCap() : 0.0;
    }

    public int getCellCount() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).getCellCount() : 0;
    }

    public int getProviderCount() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).getProviderCount() : 0;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        if (this.structure == null) {
            return new Object[]{"Unformed."};
        }
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getEnergy();
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.getMaxEnergy();
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = ((SynchronizedMatrixData)this.structure).getLastInput();
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = ((SynchronizedMatrixData)this.structure).getLastOutput();
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = ((SynchronizedMatrixData)this.structure).getTransferCap();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.ENERGY_STORAGE_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.ENERGY_STORAGE_CAPABILITY) {
            return (T)Capabilities.ENERGY_STORAGE_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }
}

