/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.IFluidContainerManager;
import mekanism.common.block.BlockBasic;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.content.tank.TankCache;
import mekanism.common.content.tank.TankUpdateProtocol;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.tile.multiblock.TileEntityMultiblock;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityDynamicTank
extends TileEntityMultiblock<SynchronizedTankData>
implements IComputerIntegration,
IFluidContainerManager {
    protected static final int[] SLOTS = new int[]{0, 1};
    public static final String[] methods = new String[]{"getAmount", "getCapacity", "getLiquidType"};
    public Set<SynchronizedTankData.ValveData> valveViewing = new ObjectOpenHashSet();
    public int clientCapacity;
    public float prevScale;

    public TileEntityDynamicTank() {
        super("DynamicTank");
    }

    public TileEntityDynamicTank(String name) {
        super(name);
        this.inventory = NonNullListSynchronized.withSize(SLOTS.length, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            if (this.clientHasStructure && this.isRendering) {
                float targetScale;
                if (this.structure != null && (double)Math.abs(this.prevScale - (targetScale = (float)(((SynchronizedTankData)this.structure).fluidStored != null ? ((SynchronizedTankData)this.structure).fluidStored.amount : (((SynchronizedTankData)this.structure).gasstored != null ? ((SynchronizedTankData)this.structure).gasstored.amount : 0)) / (float)this.clientCapacity)) > 0.01) {
                    this.prevScale = (9.0f * this.prevScale + targetScale) / 10.0f;
                }
            } else {
                for (SynchronizedTankData.ValveData data : this.valveViewing) {
                    TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = false;
                }
                this.valveViewing.clear();
            }
        } else if (this.structure != null) {
            if (((SynchronizedTankData)this.structure).fluidStored != null && ((SynchronizedTankData)this.structure).fluidStored.amount <= 0) {
                ((SynchronizedTankData)this.structure).fluidStored = null;
                this.markNoUpdateSync();
            } else if (((SynchronizedTankData)this.structure).gasstored != null && ((SynchronizedTankData)this.structure).gasstored.amount <= 0) {
                ((SynchronizedTankData)this.structure).gasstored = null;
                this.markNoUpdateSync();
            }
            if (this.isRendering) {
                boolean needsValveUpdate = false;
                for (SynchronizedTankData.ValveData data : ((SynchronizedTankData)this.structure).valves) {
                    if (data.activeTicks > 0) {
                        --data.activeTicks;
                    }
                    if (data.activeTicks > 0 != data.prevActive) {
                        needsValveUpdate = true;
                    }
                    data.prevActive = data.activeTicks > 0;
                }
                if (needsValveUpdate || ((SynchronizedTankData)this.structure).needsRenderUpdate()) {
                    this.sendPacketToRenderer();
                }
                ((SynchronizedTankData)this.structure).prevFluid = ((SynchronizedTankData)this.structure).fluidStored != null ? ((SynchronizedTankData)this.structure).fluidStored.copy() : null;
                ((SynchronizedTankData)this.structure).prevGas = ((SynchronizedTankData)this.structure).gasstored != null ? ((SynchronizedTankData)this.structure).gasstored.copy() : null;
                this.manageInventory();
            }
        }
    }

    public void manageInventory() {
        int neededFluid = ((SynchronizedTankData)this.structure).volume * TankUpdateProtocol.FLUID_PER_TANK - (((SynchronizedTankData)this.structure).fluidStored != null ? ((SynchronizedTankData)this.structure).fluidStored.amount : 0);
        if (FluidContainerUtils.isFluidContainer(((SynchronizedTankData)this.structure).inventory.get(0))) {
            ((SynchronizedTankData)this.structure).fluidStored = FluidContainerUtils.handleContainerItem(this, ((SynchronizedTankData)this.structure).inventory, ((SynchronizedTankData)this.structure).editMode, ((SynchronizedTankData)this.structure).fluidStored, neededFluid, 0, 1, null);
            Mekanism.packetHandler.sendUpdatePacket(this);
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.func_70093_af() && this.structure != null) {
            if (!BlockBasic.manageInventory(player, this, hand, stack)) {
                Mekanism.packetHandler.sendUpdatePacket(this);
                player.openGui((Object)Mekanism.instance, 18, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            } else {
                player.field_71071_by.func_70296_d();
                this.sendPacketToRenderer();
            }
            return true;
        }
        return false;
    }

    @Override
    protected SynchronizedTankData getNewStructure() {
        return new SynchronizedTankData();
    }

    public TankCache getNewCache() {
        return new TankCache();
    }

    protected TankUpdateProtocol getProtocol() {
        return new TankUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedTankData> getManager() {
        return Mekanism.tankManager;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add(((SynchronizedTankData)this.structure).volume * TankUpdateProtocol.FLUID_PER_TANK);
            data.add(((SynchronizedTankData)this.structure).editMode.ordinal());
            TileUtils.addFluidStack(data, ((SynchronizedTankData)this.structure).fluidStored);
            TileUtils.addGasStack(data, ((SynchronizedTankData)this.structure).gasstored);
            if (this.isRendering) {
                ObjectOpenHashSet toSend = new ObjectOpenHashSet();
                for (SynchronizedTankData.ValveData valveData : ((SynchronizedTankData)this.structure).valves) {
                    if (valveData.activeTicks <= 0) continue;
                    toSend.add(valveData);
                }
                data.add(toSend.size());
                for (SynchronizedTankData.ValveData valveData : toSend) {
                    valveData.location.write(data);
                    data.add(valveData.side);
                }
            }
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.clientHasStructure) {
            this.clientCapacity = dataStream.readInt();
            ((SynchronizedTankData)this.structure).editMode = FluidContainerUtils.ContainerEditMode.values()[dataStream.readInt()];
            ((SynchronizedTankData)this.structure).fluidStored = TileUtils.readFluidStack(dataStream);
            ((SynchronizedTankData)this.structure).gasstored = TileUtils.readGasStack(dataStream);
            if (this.isRendering) {
                int size = dataStream.readInt();
                this.valveViewing.clear();
                for (int i = 0; i < size; ++i) {
                    SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
                    data.location = Coord4D.read(dataStream);
                    data.side = EnumFacing.func_82600_a((int)dataStream.readInt());
                    this.valveViewing.add(data);
                    TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = true;
                }
            }
        }
    }

    public int getScaledFluidLevel(long i) {
        if (this.clientCapacity == 0 || ((SynchronizedTankData)this.structure).fluidStored == null) {
            return 0;
        }
        return (int)((long)((SynchronizedTankData)this.structure).fluidStored.amount * i / (long)this.clientCapacity);
    }

    @Override
    public FluidContainerUtils.ContainerEditMode getContainerEditMode() {
        if (this.structure != null) {
            return ((SynchronizedTankData)this.structure).editMode;
        }
        return FluidContainerUtils.ContainerEditMode.BOTH;
    }

    @Override
    public void setContainerEditMode(FluidContainerUtils.ContainerEditMode mode) {
        if (this.structure == null) {
            return;
        }
        ((SynchronizedTankData)this.structure).editMode = mode;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                (objectArray = new Object[1])[0] = this.structure != null ? (((SynchronizedTankData)this.structure).fluidStored != null ? ((SynchronizedTankData)this.structure).fluidStored.amount : (((SynchronizedTankData)this.structure).gasstored != null ? ((SynchronizedTankData)this.structure).gasstored.amount : 0)) : 0;
                break;
            }
            case 1: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.structure != null ? ((SynchronizedTankData)this.structure).volume : 0;
                break;
            }
            case 2: {
                (objectArray = new Object[1])[0] = this.structure != null ? (((SynchronizedTankData)this.structure).fluidStored != null ? ((SynchronizedTankData)this.structure).fluidStored.getLocalizedName() : (((SynchronizedTankData)this.structure).gasstored != null ? ((SynchronizedTankData)this.structure).gasstored.getGas().getLocalizedName() : null)) : null;
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }
}

