/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasStack;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.boiler.BoilerCache;
import mekanism.common.content.boiler.BoilerUpdateProtocol;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.tile.multiblock.TileEntityMultiblock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityBoilerCasing
extends TileEntityMultiblock<SynchronizedBoilerData>
implements IHeatTransfer {
    protected static final int[] INV_SLOTS = new int[]{0, 1};
    public Set<SynchronizedTankData.ValveData> valveViewing = new ObjectOpenHashSet();
    public int clientWaterCapacity;
    public int clientSteamCapacity;
    public float prevWaterScale;

    public TileEntityBoilerCasing() {
        this("BoilerCasing");
    }

    public TileEntityBoilerCasing(String name) {
        super(name);
        this.inventory = NonNullListSynchronized.withSize(INV_SLOTS.length, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            float targetScale;
            if (this.structure != null && this.clientHasStructure && this.isRendering && (double)Math.abs(this.prevWaterScale - (targetScale = (float)(((SynchronizedBoilerData)this.structure).waterStored != null ? ((SynchronizedBoilerData)this.structure).waterStored.amount : 0) / (float)this.clientWaterCapacity)) > 0.01) {
                this.prevWaterScale = (9.0f * this.prevWaterScale + targetScale) / 10.0f;
            }
            if (this.structure != null && this.clientHasStructure && this.isRendering && (double)Math.abs(this.prevWaterScale - (targetScale = (float)(((SynchronizedBoilerData)this.structure).InputGas != null ? ((SynchronizedBoilerData)this.structure).InputGas.amount : 0) / (float)this.clientWaterCapacity)) > 0.01) {
                this.prevWaterScale = (9.0f * this.prevWaterScale + targetScale) / 10.0f;
            }
            if (!this.clientHasStructure || !this.isRendering) {
                for (SynchronizedTankData.ValveData valveData : this.valveViewing) {
                    TileEntityBoilerCasing tileEntity = (TileEntityBoilerCasing)valveData.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = false;
                }
                this.valveViewing.clear();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.structure != null) {
            if (((SynchronizedBoilerData)this.structure).waterStored != null && ((SynchronizedBoilerData)this.structure).waterStored.amount <= 0) {
                ((SynchronizedBoilerData)this.structure).waterStored = null;
                this.markNoUpdateSync();
            }
            if (((SynchronizedBoilerData)this.structure).steamStored != null && ((SynchronizedBoilerData)this.structure).steamStored.amount <= 0) {
                ((SynchronizedBoilerData)this.structure).steamStored = null;
                this.markNoUpdateSync();
            }
            if (((SynchronizedBoilerData)this.structure).InputGas != null && ((SynchronizedBoilerData)this.structure).InputGas.amount <= 0) {
                ((SynchronizedBoilerData)this.structure).InputGas = null;
                this.markNoUpdateSync();
            }
            if (((SynchronizedBoilerData)this.structure).OutputGas != null && ((SynchronizedBoilerData)this.structure).OutputGas.amount <= 0) {
                ((SynchronizedBoilerData)this.structure).OutputGas = null;
                this.markNoUpdateSync();
            }
            if (this.isRendering) {
                int amountToBoil;
                double heatAvailable;
                boolean bl;
                boolean newHot;
                boolean needsValveUpdate = false;
                for (SynchronizedTankData.ValveData data : ((SynchronizedBoilerData)this.structure).valves) {
                    if (data.activeTicks > 0) {
                        --data.activeTicks;
                    }
                    if (data.activeTicks > 0 != data.prevActive) {
                        needsValveUpdate = true;
                    }
                    data.prevActive = data.activeTicks > 0;
                }
                boolean bl2 = false;
                boolean bl3 = newHot = ((SynchronizedBoilerData)this.structure).temperature >= SynchronizedBoilerData.BASE_BOIL_TEMP - (double)0.01f;
                if (newHot != ((SynchronizedBoilerData)this.structure).clientHot) {
                    bl = true;
                    ((SynchronizedBoilerData)this.structure).clientHot = newHot;
                }
                double[] d = ((SynchronizedBoilerData)this.structure).simulateHeat();
                ((SynchronizedBoilerData)this.structure).applyTemperatureChange();
                ((SynchronizedBoilerData)this.structure).lastEnvironmentLoss = d[1];
                if (((SynchronizedBoilerData)this.structure).InputGas != null) {
                    int OutputAmount = ((SynchronizedBoilerData)this.structure).OutputGas != null ? ((SynchronizedBoilerData)this.structure).OutputGas.amount : 0;
                    heatAvailable = ((SynchronizedBoilerData)this.structure).getTemp();
                    ((SynchronizedBoilerData)this.structure).lastMaxBoil = (int)Math.floor(heatAvailable / SynchronizedBoilerData.getHeatEnthalpy());
                    amountToBoil = Math.min(((SynchronizedBoilerData)this.structure).lastMaxBoil, ((SynchronizedBoilerData)this.structure).InputGas.amount);
                    amountToBoil = Math.min(amountToBoil, ((SynchronizedBoilerData)this.structure).steamVolume * 160000 - OutputAmount);
                    ((SynchronizedBoilerData)this.structure).InputGas.amount -= amountToBoil;
                    if (((SynchronizedBoilerData)this.structure).OutputGas == null) {
                        ((SynchronizedBoilerData)this.structure).OutputGas = new GasStack(MekanismFluids.Sodium, amountToBoil);
                    } else {
                        ((SynchronizedBoilerData)this.structure).OutputGas.amount += amountToBoil;
                    }
                    if (((SynchronizedBoilerData)this.structure).OutputGas.amount != ((SynchronizedBoilerData)this.structure).steamVolume * 160000) {
                        ((SynchronizedBoilerData)this.structure).temperature += (double)amountToBoil * SynchronizedBoilerData.getHeatEnthalpy() / (double)((SynchronizedBoilerData)this.structure).locations.size();
                        ((SynchronizedBoilerData)this.structure).lastBoilRate = amountToBoil;
                    }
                }
                if (((SynchronizedBoilerData)this.structure).temperature >= SynchronizedBoilerData.BASE_BOIL_TEMP && ((SynchronizedBoilerData)this.structure).waterStored != null) {
                    int steamAmount = ((SynchronizedBoilerData)this.structure).steamStored != null ? ((SynchronizedBoilerData)this.structure).steamStored.amount : 0;
                    heatAvailable = ((SynchronizedBoilerData)this.structure).getHeatAvailable();
                    ((SynchronizedBoilerData)this.structure).lastMaxBoil = (int)Math.floor(heatAvailable / SynchronizedBoilerData.getHeatEnthalpy());
                    amountToBoil = Math.min(((SynchronizedBoilerData)this.structure).lastMaxBoil, ((SynchronizedBoilerData)this.structure).waterStored.amount);
                    amountToBoil = Math.min(amountToBoil, ((SynchronizedBoilerData)this.structure).steamVolume * 160000 - steamAmount);
                    ((SynchronizedBoilerData)this.structure).waterStored.amount -= amountToBoil;
                    if (((SynchronizedBoilerData)this.structure).steamStored == null) {
                        ((SynchronizedBoilerData)this.structure).steamStored = new FluidStack(FluidRegistry.getFluid((String)"steam"), amountToBoil);
                    } else {
                        ((SynchronizedBoilerData)this.structure).steamStored.amount += amountToBoil;
                    }
                    ((SynchronizedBoilerData)this.structure).temperature -= (double)amountToBoil * SynchronizedBoilerData.getHeatEnthalpy() / (double)((SynchronizedBoilerData)this.structure).locations.size();
                    ((SynchronizedBoilerData)this.structure).lastBoilRate = amountToBoil;
                } else {
                    ((SynchronizedBoilerData)this.structure).lastBoilRate = 0;
                    ((SynchronizedBoilerData)this.structure).lastMaxBoil = 0;
                }
                if (needsValveUpdate || ((SynchronizedBoilerData)this.structure).needsRenderUpdate() || bl) {
                    this.sendPacketToRenderer();
                }
                ((SynchronizedBoilerData)this.structure).prevWater = ((SynchronizedBoilerData)this.structure).waterStored != null ? ((SynchronizedBoilerData)this.structure).waterStored.copy() : null;
                ((SynchronizedBoilerData)this.structure).prevSteam = ((SynchronizedBoilerData)this.structure).steamStored != null ? ((SynchronizedBoilerData)this.structure).steamStored.copy() : null;
                ((SynchronizedBoilerData)this.structure).prevInputGas = ((SynchronizedBoilerData)this.structure).InputGas != null ? ((SynchronizedBoilerData)this.structure).InputGas.copy() : null;
                ((SynchronizedBoilerData)this.structure).prevOutputGas = ((SynchronizedBoilerData)this.structure).OutputGas != null ? ((SynchronizedBoilerData)this.structure).OutputGas.copy() : null;
                MekanismUtils.saveChunk(this);
            }
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.func_70093_af() && this.structure != null) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            player.openGui((Object)Mekanism.instance, 54, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    protected SynchronizedBoilerData getNewStructure() {
        return new SynchronizedBoilerData();
    }

    public BoilerCache getNewCache() {
        return new BoilerCache();
    }

    protected BoilerUpdateProtocol getProtocol() {
        return new BoilerUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedBoilerData> getManager() {
        return Mekanism.boilerManager;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add(((SynchronizedBoilerData)this.structure).waterVolume * 16000);
            data.add(((SynchronizedBoilerData)this.structure).steamVolume * 160000);
            data.add(((SynchronizedBoilerData)this.structure).lastEnvironmentLoss);
            data.add(((SynchronizedBoilerData)this.structure).lastBoilRate);
            data.add(((SynchronizedBoilerData)this.structure).superheatingElements);
            data.add(((SynchronizedBoilerData)this.structure).temperature);
            data.add(((SynchronizedBoilerData)this.structure).lastMaxBoil);
            TileUtils.addFluidStack(data, ((SynchronizedBoilerData)this.structure).waterStored);
            TileUtils.addFluidStack(data, ((SynchronizedBoilerData)this.structure).steamStored);
            TileUtils.addGasStack(data, ((SynchronizedBoilerData)this.structure).InputGas);
            TileUtils.addGasStack(data, ((SynchronizedBoilerData)this.structure).OutputGas);
            ((SynchronizedBoilerData)this.structure).upperRenderLocation.write(data);
            if (this.isRendering) {
                data.add(((SynchronizedBoilerData)this.structure).clientHot);
                ObjectOpenHashSet toSend = new ObjectOpenHashSet();
                for (SynchronizedTankData.ValveData valveData : ((SynchronizedBoilerData)this.structure).valves) {
                    if (valveData.activeTicks <= 0) continue;
                    toSend.add(valveData);
                }
                data.add(toSend.size());
                for (SynchronizedTankData.ValveData valveData : toSend) {
                    valveData.location.write(data);
                    data.add(valveData.side.ordinal());
                }
            }
        }
        return data;
    }

    public double getLastEnvironmentLoss() {
        return this.structure != null ? ((SynchronizedBoilerData)this.structure).lastEnvironmentLoss : 0.0;
    }

    public double getTemperature() {
        return this.structure != null ? ((SynchronizedBoilerData)this.structure).temperature : 0.0;
    }

    public int getLastBoilRate() {
        return this.structure != null ? ((SynchronizedBoilerData)this.structure).lastBoilRate : 0;
    }

    public int getLastMaxBoil() {
        return this.structure != null ? ((SynchronizedBoilerData)this.structure).lastMaxBoil : 0;
    }

    public int getSuperheatingElements() {
        return this.structure != null ? ((SynchronizedBoilerData)this.structure).superheatingElements : 0;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.clientHasStructure) {
            this.clientWaterCapacity = dataStream.readInt();
            this.clientSteamCapacity = dataStream.readInt();
            ((SynchronizedBoilerData)this.structure).lastEnvironmentLoss = dataStream.readDouble();
            ((SynchronizedBoilerData)this.structure).lastBoilRate = dataStream.readInt();
            ((SynchronizedBoilerData)this.structure).superheatingElements = dataStream.readInt();
            ((SynchronizedBoilerData)this.structure).temperature = dataStream.readDouble();
            ((SynchronizedBoilerData)this.structure).lastMaxBoil = dataStream.readInt();
            ((SynchronizedBoilerData)this.structure).waterStored = TileUtils.readFluidStack(dataStream);
            ((SynchronizedBoilerData)this.structure).steamStored = TileUtils.readFluidStack(dataStream);
            ((SynchronizedBoilerData)this.structure).InputGas = TileUtils.readGasStack(dataStream);
            ((SynchronizedBoilerData)this.structure).OutputGas = TileUtils.readGasStack(dataStream);
            ((SynchronizedBoilerData)this.structure).upperRenderLocation = Coord4D.read(dataStream);
            if (this.isRendering) {
                ((SynchronizedBoilerData)this.structure).clientHot = dataStream.readBoolean();
                SynchronizedBoilerData.clientHotMap.put(((SynchronizedBoilerData)this.structure).inventoryID, ((SynchronizedBoilerData)this.structure).clientHot);
                int size = dataStream.readInt();
                this.valveViewing.clear();
                for (int i = 0; i < size; ++i) {
                    SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
                    data.location = Coord4D.read(dataStream);
                    data.side = EnumFacing.func_82600_a((int)dataStream.readInt());
                    this.valveViewing.add(data);
                    TileEntityBoilerCasing tileEntity = (TileEntityBoilerCasing)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = true;
                }
            }
        }
    }

    @Override
    public double getTemp() {
        return 0.0;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return SynchronizedBoilerData.CASING_INVERSE_CONDUCTION_COEFFICIENT;
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return SynchronizedBoilerData.CASING_INSULATION_COEFFICIENT;
    }

    @Override
    public void transferHeatTo(double heat) {
        if (this.structure != null) {
            ((SynchronizedBoilerData)this.structure).heatToAbsorb += heat;
        }
    }

    @Override
    public double[] simulateHeat() {
        return new double[]{0.0, 0.0};
    }

    @Override
    public double applyTemperatureChange() {
        return 0.0;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return this.structure != null;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.HEAT_TRANSFER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)Capabilities.HEAT_TRANSFER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize("gui.thermoelectricBoiler");
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }
}

