/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.prefab.TileEntityBasicMachine;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySolarNeutronActivator
extends TileEntityBasicMachine<GasInput, GasOutput, SolarNeutronRecipe>
implements IBoundingBlock,
IGasHandler,
ISustainedData,
ITankManager,
Upgrade.IUpgradeInfoHandler {
    public static final int MAX_GAS = 10000;
    public GasTank inputTank = new GasTank(10000);
    public GasTank outputTank = new GasTank(10000);
    private SolarNeutronRecipe cachedRecipe;
    private int currentRedstoneLevel;
    private boolean isActive;
    private boolean needsRainCheck;

    public TileEntitySolarNeutronActivator() {
        super("SolarNeutronActivator", BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR, 2, 1);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{1, -1, 2, 1, 1, 1});
        this.configComponent.setCanEject(TransmissionType.ITEM, false);
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(new int[]{0, 1}, new boolean[]{false, true}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{1, -1, 2, 1, 1, 1});
        this.inventory = NonNullListSynchronized.withSize(3, ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(2));
        this.ejectorComponent.setInputOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(3));
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.needsRainCheck = this.field_145850_b.field_73011_w.getBiomeForCoords(this.func_174877_v()).func_76738_d();
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            int newRedstoneLevel;
            boolean seesSun;
            IGasItem item;
            Item item2;
            ItemStack stack = (ItemStack)this.inventory.get(0);
            if (!stack.func_190926_b() && (item2 = stack.func_77973_b()) instanceof IGasItem && (item = (IGasItem)item2).getGas(stack) != null && RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.containsRecipe(item.getGas(stack).getGas())) {
                TileUtils.receiveGasItem((ItemStack)this.inventory.get(0), this.inputTank);
            }
            TileUtils.drawGas((ItemStack)this.inventory.get(1), this.outputTank);
            SolarNeutronRecipe recipe = this.getRecipe();
            boolean bl = seesSun = this.field_145850_b.func_72935_r() && this.field_145850_b.func_175678_i(this.func_174877_v().func_177984_a()) && !this.field_145850_b.field_73011_w.func_177495_o();
            if (this.needsRainCheck) {
                seesSun &= !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I();
            }
            if (seesSun && this.canOperate(recipe) && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                this.operate(recipe);
            } else {
                this.setActive(false);
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            if ((newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
                this.updateComparatorOutputLevelSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    public int getUpgradedUsage(SolarNeutronRecipe recipe) {
        int possibleProcess = Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), MekanismConfig.current().mekce.MAXspeedmachines.val());
        possibleProcess = Math.min(Math.min(this.inputTank.getStored(), this.outputTank.getNeeded()), possibleProcess);
        return Math.min(this.inputTank.getStored() / ((GasInput)recipe.recipeInput).ingredient.amount, possibleProcess);
    }

    @Override
    public SolarNeutronRecipe getRecipe() {
        GasInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((GasInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getSolarNeutronRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    @Override
    public GasInput getInput() {
        return new GasInput(this.inputTank.getGas());
    }

    @Override
    public boolean canOperate(SolarNeutronRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inputTank, this.outputTank);
    }

    @Override
    public void operate(SolarNeutronRecipe recipe) {
        recipe.operate(this.inputTank, this.outputTank, this.getUpgradedUsage(recipe));
    }

    @Override
    public Map<GasInput, SolarNeutronRecipe> getRecipes() {
        return RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.isActive = dataStream.readBoolean();
            TileUtils.readTankData(dataStream, this.inputTank);
            TileUtils.readTankData(dataStream, this.outputTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        TileUtils.addTankData(data, this.inputTank);
        TileUtils.addTankData(data, this.outputTank);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.inputTank.read(nbtTags.func_74775_l("inputTank"));
        this.outputTank.read(nbtTags.func_74775_l("outputTank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74782_a("inputTank", (NBTBase)this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("outputTank", (NBTBase)this.outputTank.write(new NBTTagCompound()));
    }

    @Override
    public void onPlace() {
        MekanismUtils.makeBoundingBlock(this.field_145850_b, Coord4D.get(this).offset(EnumFacing.UP).getPos(), Coord4D.get(this));
    }

    @Override
    public void onBreak() {
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177984_a());
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            int recipeAmount = ((GasInput)((SolarNeutronRecipe)RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get().get((Object)new GasInput((GasStack)stack))).recipeInput).ingredient.amount;
            int receivable = this.inputTank.receive(stack, false);
            int stored = this.inputTank.stored != null ? this.inputTank.stored.amount : 0;
            int newStored = stored + receivable;
            int amount = newStored - stored - newStored % recipeAmount;
            return this.inputTank.receive(stack.copy().withAmount(amount), doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.outputTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0) && this.inputTank.canReceive(type) && RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.containsRecipe(type);
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1) && this.outputTank.canDraw(type);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.inputTank, this.outputTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputTank", this.inputTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "outputTank", this.outputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputTank")));
        this.outputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "outputTank")));
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputTank, this.outputTank};
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof IGasItem;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getStored(), this.inputTank.getMaxGas());
    }

    @Override
    public String[] getMethods() {
        return new String[0];
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        return new Object[0];
    }
}

