/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.FluidTankSync;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityRotaryCondensentrator
extends TileEntityMachine
implements ISustainedData,
IFluidHandlerWrapper,
IGasHandler,
Upgrade.IUpgradeInfoHandler,
ITankManager,
IComparatorSupport,
ISideConfiguration {
    public static final int MAX_FLUID = 10000;
    public GasTank gasTank = new GasTank(10000);
    public FluidTank fluidTank = new FluidTankSync(10000);
    public int mode;
    public int gasOutput = 256;
    public double clientEnergyUsed;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS, TransmissionType.FLUID);
    private int currentRedstoneLevel;

    public TileEntityRotaryCondensentrator() {
        super("machine.rotarycondensentrator", BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR, 5);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{4}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.FLUID, new int[]{2, 3}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.GAS, new int[]{0, 1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{2, 1, 2, 2, 3, 2});
        this.configComponent.addOutput(TransmissionType.FLUID, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.FLUID, new SideData(DataType.FLUID, new int[]{0}));
        this.configComponent.setConfig(TransmissionType.FLUID, new byte[]{0, 0, 0, 0, 0, 1});
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.GAS, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{0, 0, 0, 0, 1, 0});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullListSynchronized.withSize(6, ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(1));
        this.ejectorComponent.setOutputData(TransmissionType.FLUID, this.configComponent.getOutputs(TransmissionType.FLUID).get(1));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            int operations;
            ChargeUtils.discharge(4, this);
            if (!MekanismConfig.current().mekce.RotaryCondensentratorAuto.val()) {
                this.Autoeject();
            }
            if (this.mode == 0) {
                TileUtils.receiveGasItem((ItemStack)this.inventory.get(1), this.gasTank);
                if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(2))) {
                    FluidContainerUtils.handleContainerItemFill(this, this.fluidTank, 2, 3);
                    if (this.fluidTank.getFluid() != null && this.fluidTank.getFluidAmount() == 0) {
                        this.fluidTank.setFluid(null);
                    }
                }
                if (this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this) && this.isValidGas(this.gasTank.getGas()) && (this.fluidTank.getFluid() == null || this.fluidTank.getFluidAmount() < 10000 && this.gasEquals(this.gasTank.getGas(), this.fluidTank.getFluid()))) {
                    operations = this.getUpgradedUsage();
                    double prev = this.getEnergy();
                    this.setActive(true);
                    this.fluidTank.fill(new FluidStack(this.gasTank.stored.getGas().getFluid(), operations), true);
                    this.gasTank.draw(operations, true);
                    this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                    this.clientEnergyUsed = prev - this.getEnergy();
                } else if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            } else if (this.mode == 1) {
                TileUtils.drawGas((ItemStack)this.inventory.get(0), this.gasTank);
                if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(2)) && this.fluidTank.getFluidAmount() != this.fluidTank.getCapacity()) {
                    FluidContainerUtils.handleContainerItemEmpty(this, this.fluidTank, 2, 3);
                }
                if (this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this) && this.isValidFluid(this.fluidTank.getFluid()) && (this.gasTank.getGas() == null || this.gasTank.getStored() < 10000 && this.gasEquals(this.gasTank.getGas(), this.fluidTank.getFluid()))) {
                    operations = this.getUpgradedUsage();
                    double prev = this.getEnergy();
                    this.setActive(true);
                    this.gasTank.receive(new GasStack(GasRegistry.getGas(this.fluidTank.getFluid().getFluid()), operations), true);
                    this.fluidTank.drain(operations, true);
                    this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                    this.clientEnergyUsed = prev - this.getEnergy();
                } else if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            this.prevEnergy = this.getEnergy();
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.updateComparatorOutputLevelSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    public void Autoeject() {
        if (this.mode == 0) {
            this.configComponent.setEjecting(TransmissionType.GAS, false);
            this.configComponent.setEjecting(TransmissionType.FLUID, true);
        } else if (this.mode == 1) {
            this.configComponent.setEjecting(TransmissionType.GAS, true);
            this.configComponent.setEjecting(TransmissionType.FLUID, false);
        }
    }

    public int getUpgradedUsage() {
        int possibleProcess = Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), MekanismConfig.current().mekce.MAXspeedmachines.val());
        possibleProcess = this.mode == 0 ? Math.min(Math.min(this.gasTank.getStored(), this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount()), possibleProcess) : Math.min(Math.min(this.fluidTank.getFluidAmount(), this.gasTank.getNeeded()), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return Math.min(this.mode == 0 ? this.gasTank.getStored() : this.fluidTank.getFluidAmount(), possibleProcess);
    }

    public boolean isValidGas(GasStack g) {
        return g != null && g.getGas().hasFluid();
    }

    public boolean gasEquals(GasStack gas, FluidStack fluid) {
        return fluid != null && gas != null && gas.getGas().hasFluid() && gas.getGas().getFluid() == fluid.getFluid();
    }

    public boolean isValidFluid(@Nonnull Fluid f) {
        return GasRegistry.getGas(f) != null;
    }

    public boolean isValidFluid(FluidStack f) {
        return f != null && this.isValidFluid(f.getFluid());
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.mode = this.mode == 0 ? 1 : 0;
            }
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(this), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.mode = dataStream.readInt();
            this.clientEnergyUsed = dataStream.readDouble();
            TileUtils.readTankData(dataStream, this.fluidTank);
            TileUtils.readTankData(dataStream, this.gasTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.mode);
        data.add(this.clientEnergyUsed);
        TileUtils.addTankData(data, this.fluidTank);
        TileUtils.addTankData(data, this.gasTank);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.mode = nbtTags.func_74762_e("mode");
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("mode", this.mode);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.gasTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.mode == 1 && this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1) && this.gasTank.canDraw(type);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.mode == 0 && this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1) && this.gasTank.canReceive(type);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        return this.configComponent.isCapabilityDisabled(capability, side, this.facing) || super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "fluidTank", this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.gasTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "gasTank", this.gasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank")));
        this.gasTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "gasTank")));
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource, doFill);
    }

    @Override
    @Nullable
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        return this.mode == 1 && this.configComponent.getOutput(TransmissionType.FLUID, from, this.facing).hasSlot(0) && FluidContainerUtils.canFill(this.fluidTank.getFluid(), fluid);
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return this.mode == 0 && this.configComponent.getOutput(TransmissionType.FLUID, from, this.facing).hasSlot(0) && FluidContainerUtils.canDrain(this.fluidTank.getFluid(), fluid);
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        SideData data = this.configComponent.getOutput(TransmissionType.FLUID, from, this.facing);
        return data.getFluidTankInfo(this);
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank, this.gasTank};
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            return stack.func_77973_b() instanceof IGasItem;
        }
        if (slot == 2) {
            return FluidContainerUtils.isFluidContainer(stack);
        }
        if (slot == 4) {
            return ChargeUtils.canBeDischarged(stack);
        }
        return false;
    }

    @Override
    public int getRedstoneLevel() {
        if (this.mode == 0) {
            return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getMaxGas());
        }
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }
}

