/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.ItemUpgrade;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.outputs.PressurizedOutput;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.prefab.TileEntityUpgradeableMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.FluidTankSync;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityPRC
extends TileEntityUpgradeableMachine<PressurizedInput, PressurizedOutput, PressurizedRecipe>
implements IFluidHandlerWrapper,
IGasHandler,
ISustainedData,
ITankManager {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded", "getFluidStored", "getGasStored"};
    public FluidTank inputFluidTank = new FluidTankSync(10000);
    public GasTank inputGasTank = new GasTank(10000);
    public GasTank outputGasTank = new GasTank(10000);

    public TileEntityPRC() {
        super("prc", BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER, 3, 100);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.FLUID, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(new int[]{0, 2}, new boolean[]{false, true}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_ENHANCED, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_ENHANCED_OUTPUT_ENHANCED, new int[]{0, 2}, new boolean[]{false, true}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{1, 1, 1, 2, 1, 3});
        this.configComponent.setInputConfig(TransmissionType.FLUID);
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.INPUT, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(new int[]{1, 2}, new boolean[]{false, true}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{1, 1, 1, 1, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullListSynchronized.withSize(4, ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(3));
        this.ejectorComponent.setInputOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(4));
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(2));
        this.ejectorComponent.setInputOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(3));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> {
                this.AutomaticallyExtractItems(5, 0);
                this.AutomaticallyExtractItems(6, 0);
                this.BetterEjectingItem(6, 2);
            });
            PressurizedRecipe recipe = this.getRecipe();
            ChargeUtils.discharge(1, this);
            if (this.canOperate(recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy)) {
                boolean update = this.BASE_TICKS_REQUIRED != recipe.ticks;
                this.BASE_TICKS_REQUIRED = recipe.ticks;
                if (update) {
                    this.recalculateUpgradables(Upgrade.SPEED);
                }
                this.setActive(true);
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                    this.electricityStored.addAndGet(-MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy));
                } else if (this.operatingTicks + 1 >= this.ticksRequired && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy)) {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                    this.electricityStored.addAndGet(-MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy));
                }
            } else {
                this.BASE_TICKS_REQUIRED = 100;
                if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            if (!this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    protected void upgradeInventory(TileEntityFactory factory) {
        factory.gasTank.setGas(this.inputGasTank.getGas());
        factory.gasOutTank.setGas(this.outputGasTank.getGas());
        factory.fluidTank.setFluid(this.inputFluidTank.getFluid());
        factory.inventory.set(5, (ItemStack)this.inventory.get(0));
        factory.inventory.set(1, (ItemStack)this.inventory.get(1));
        factory.inventory.set(8, (ItemStack)this.inventory.get(2));
        factory.inventory.set(0, (ItemStack)this.inventory.get(3));
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.isInPressurizedRecipe(itemstack);
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 3) {
            return itemstack.func_77973_b() instanceof ItemUpgrade;
        }
        return false;
    }

    @Override
    public PressurizedRecipe getRecipe() {
        PressurizedInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((PressurizedInput)((PressurizedRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getPRCRecipe(input);
        }
        return (PressurizedRecipe)this.cachedRecipe;
    }

    @Override
    public PressurizedInput getInput() {
        return new PressurizedInput((ItemStack)this.inventory.get(0), this.inputFluidTank.getFluid(), this.inputGasTank.getGas());
    }

    @Override
    public void operate(PressurizedRecipe recipe) {
        recipe.operate(this.inventory, 0, this.inputFluidTank, this.inputGasTank, this.outputGasTank, 2);
        this.markNoUpdateSync();
    }

    @Override
    public boolean canOperate(PressurizedRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inventory, 0, this.inputFluidTank, this.inputGasTank, this.outputGasTank, 2);
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2 || slotID == 4;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.inputFluidTank);
        TileUtils.addTankData(data, this.inputGasTank);
        TileUtils.addTankData(data, this.outputGasTank);
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.inputFluidTank);
            TileUtils.readTankData(dataStream, this.inputGasTank);
            TileUtils.readTankData(dataStream, this.outputGasTank);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.inputFluidTank.readFromNBT(nbtTags.func_74775_l("inputFluidTank"));
        this.inputGasTank.read(nbtTags.func_74775_l("inputGasTank"));
        this.outputGasTank.read(nbtTags.func_74775_l("outputGasTank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("inputFluidTank", (NBTBase)this.inputFluidTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("inputGasTank", (NBTBase)this.inputGasTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("outputGasTank", (NBTBase)this.outputGasTank.write(new NBTTagCompound()));
    }

    @Override
    public Map<PressurizedInput, PressurizedRecipe> getRecipes() {
        return RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get();
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getEnergy();
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.operatingTicks;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.isActive;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.facing;
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = this.canOperate(this.getRecipe());
                break;
            }
            case 5: {
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = this.getMaxEnergy();
                break;
            }
            case 6: {
                Object[] objectArray8 = new Object[1];
                objectArray = objectArray8;
                objectArray8[0] = this.getMaxEnergy() - this.getEnergy();
                break;
            }
            case 7: {
                Object[] objectArray9 = new Object[1];
                objectArray = objectArray9;
                objectArray9[0] = this.inputFluidTank.getFluidAmount();
                break;
            }
            case 8: {
                Object[] objectArray10 = new Object[1];
                objectArray = objectArray10;
                objectArray10[0] = this.inputGasTank.getStored();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.inputFluidTank.fill(resource, doFill);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        if (this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState == SideData.IOState.INPUT) {
            return FluidContainerUtils.canFill(this.inputFluidTank.getFluid(), fluid);
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState != SideData.IOState.OFF) {
            return new FluidTankInfo[]{this.inputFluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return new FluidTankInfo[]{this.inputFluidTank.getInfo()};
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.inputGasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.outputGasTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1) & this.inputGasTank.canReceive(type) && RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.containsRecipe(type);
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(2) && this.outputGasTank.canDraw(type);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.inputGasTank, this.outputGasTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputFluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "inputFluidTank", this.inputFluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.inputGasTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputGasTank", this.inputGasTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputGasTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "outputGasTank", this.outputGasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputFluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "inputFluidTank")));
        this.inputGasTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputGasTank")));
        this.outputGasTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "outputGasTank")));
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputFluidTank, this.inputGasTank, this.outputGasTank};
    }
}

