/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.IConfigCardAccess;
import mekanism.api.TileNetworkList;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.filter.IFilter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityOredictionificator
extends TileEntityContainerBlock
implements IRedstoneControl,
IConfigCardAccess.ISpecialConfigData,
ISustainedData,
ISecurityTile,
ISideConfiguration {
    public static List<String> possibleFilters = Arrays.asList("ingot", "ore", "dust", "nugget");
    public HashList<OredictionificatorFilter> filters = new HashList();
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;
    public boolean didProcess;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityOredictionificator() {
        super(BlockStateMachine.MachineType.OREDICTIONIFICATOR.getBlockName());
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(new int[]{0, 1}, new boolean[]{false, true}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{1, 1, 1, 1, 1, 2});
        this.inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.ejectorComponent.setInputOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(3));
        this.doAutoSync = false;
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack result;
            if (this.playersUsing.size() > 0) {
                for (EntityPlayer player : this.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(this, this.getGenericPacket(new TileNetworkList())), (EntityPlayerMP)player);
                }
            }
            this.didProcess = false;
            ItemStack inputStack = (ItemStack)this.inventory.get(0);
            if (MekanismUtils.canFunction(this) && !inputStack.func_190926_b() && this.getValidName(inputStack) != null && !(result = this.getResult(inputStack)).func_190926_b()) {
                ItemStack outputStack = (ItemStack)this.inventory.get(1);
                if (outputStack.func_190926_b()) {
                    inputStack.func_190918_g(1);
                    if (inputStack.func_190916_E() <= 0) {
                        this.inventory.set(0, ItemStack.field_190927_a);
                    }
                    this.inventory.set(1, result);
                    this.didProcess = true;
                } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)result) && outputStack.func_190916_E() < outputStack.func_77976_d()) {
                    inputStack.func_190918_g(1);
                    if (inputStack.func_190916_E() <= 0) {
                        this.inventory.set(0, ItemStack.field_190927_a);
                    }
                    outputStack.func_190917_f(1);
                    this.didProcess = true;
                }
                this.markNoUpdateSync();
            }
        }
    }

    public String getValidName(ItemStack stack) {
        List<String> def = OreDictCache.getOreDictName(stack);
        for (String s : def) {
            for (String pre : possibleFilters) {
                if (!s.startsWith(pre)) continue;
                return s;
            }
        }
        return null;
    }

    public ItemStack getResult(ItemStack stack) {
        String s = this.getValidName(stack);
        if (s == null) {
            return ItemStack.field_190927_a;
        }
        NonNullList ores = OreDictionary.getOres((String)s, (boolean)false);
        for (OredictionificatorFilter filter : this.filters) {
            if (!filter.filter.equals(s)) continue;
            if (ores.size() - 1 >= filter.index) {
                return StackUtils.size((ItemStack)ores.get(filter.index), 1);
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        return slotID == 1;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 1) {
            return false;
        }
        if (slotID == 0) {
            return !this.getResult(itemstack).func_190926_b();
        }
        return false;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        NBTTagList filterTags = new NBTTagList();
        for (OredictionificatorFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(OredictionificatorFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
        if (this.facing.func_176740_k() == EnumFacing.Axis.Y) {
            this.facing = EnumFacing.NORTH;
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        block2: {
            int type;
            block4: {
                block3: {
                    super.handlePacketData(dataStream);
                    if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) break block2;
                    type = dataStream.readInt();
                    if (type != 0) break block3;
                    this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
                    this.didProcess = dataStream.readBoolean();
                    this.filters.clear();
                    int amount = dataStream.readInt();
                    for (int i = 0; i < amount; ++i) {
                        this.filters.add(OredictionificatorFilter.readFromPacket(dataStream));
                    }
                    break block2;
                }
                if (type != 1) break block4;
                this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
                this.didProcess = dataStream.readBoolean();
                break block2;
            }
            if (type != 2) break block2;
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(OredictionificatorFilter.readFromPacket(dataStream));
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(0);
        data.add(this.controlType.ordinal());
        data.add(this.didProcess);
        data.add(this.filters.size());
        for (OredictionificatorFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public TileNetworkList getGenericPacket(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(1);
        data.add(this.controlType.ordinal());
        data.add(this.didProcess);
        return data;
    }

    public TileNetworkList getFilterPacket(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(2);
        data.add(this.filters.size());
        for (OredictionificatorFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    @Override
    public void func_174889_b(@Nonnull EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendUpdatePacket(this);
        }
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        NBTTagList filterTags = new NBTTagList();
        for (OredictionificatorFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(OredictionificatorFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setBoolean(itemStack, "hasOredictionificatorConfig", true);
        NBTTagList filterTags = new NBTTagList();
        for (OredictionificatorFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "hasOredictionificatorConfig") && ItemDataUtils.hasData(itemStack, "filters")) {
            NBTTagList tagList = ItemDataUtils.getList(itemStack, "filters");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(OredictionificatorFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        return this.configComponent.isCapabilityDisabled(capability, side, this.facing) || super.isCapabilityDisabled(capability, side);
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    public static class OredictionificatorFilter
    implements IFilter {
        public String filter;
        public int index;

        public static OredictionificatorFilter readFromNBT(NBTTagCompound nbtTags) {
            OredictionificatorFilter filter = new OredictionificatorFilter();
            filter.read(nbtTags);
            return filter;
        }

        public static OredictionificatorFilter readFromPacket(ByteBuf dataStream) {
            OredictionificatorFilter filter = new OredictionificatorFilter();
            filter.read(dataStream);
            return filter;
        }

        public void write(NBTTagCompound nbtTags) {
            nbtTags.func_74778_a("filter", this.filter);
            nbtTags.func_74768_a("index", this.index);
        }

        protected void read(NBTTagCompound nbtTags) {
            this.filter = nbtTags.func_74779_i("filter");
            this.index = nbtTags.func_74762_e("index");
        }

        public void write(TileNetworkList data) {
            data.add(this.filter);
            data.add(this.index);
        }

        protected void read(ByteBuf dataStream) {
            this.filter = PacketHandler.readString(dataStream);
            this.index = dataStream.readInt();
        }

        public OredictionificatorFilter clone() {
            OredictionificatorFilter newFilter = new OredictionificatorFilter();
            newFilter.filter = this.filter;
            newFilter.index = this.index;
            return newFilter;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.filter.hashCode();
            return code;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof OredictionificatorFilter)) return false;
            OredictionificatorFilter ore = (OredictionificatorFilter)obj;
            if (!ore.filter.equals(this.filter)) return false;
            return true;
        }
    }
}

